% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataviewer.R
\name{dataviewer}
\alias{dataviewer}
\title{Interactive Data Viewer with Filter and Code Generation}
\usage{
dataviewer(..., background = NULL, port = NULL)
}
\arguments{
\item{...}{One or more \code{data.frame} or \code{tibble} objects. If none provided, an import UI is shown to load data interactively.}

\item{background}{Logical. If \code{TRUE}, runs the app in a background R process using \code{callr}. Requires the \code{callr} package. Default is TRUE when dataset(s) are provided, FALSE when no dataset(s) are provided.}

\item{port}{Integer. Port number for the Shiny app. If \code{NULL}, a random available port is used. Default is NULL.}
}
\value{
If \code{background = TRUE}, returns the process ID (character) invisibly.
If \code{background = FALSE}, returns a Shiny application object.
}
\description{
Launches a Shiny application to explore and filter a \code{data.frame} or \code{tibble}.
If no data is provided, it opens an import panel to load a dataset from either the global environment or the packages.
}
\details{
This function provides:
\itemize{
\item A tab-based interface with data import and viewer options.
\item Support for multiple datasets in separate tabs.
\item A checkbox panel to select/deselect columns.
\item An input for \code{dplyr}-compatible filter expressions.
\item A dynamically generated \code{dplyr} code preview.
\item Metadata display for the variables.
}

The filtering uses \code{dplyr::filter()} and generates user-friendly code to replicate the steps.
It also provides copyable R code that includes column selection and filtering logic.
}
\examples{
if (interactive()) {
    dataviewer(mtcars) # Opens in RStudio Viewer pane or default web browser
    dataviewer(iris, mtcars) # Opens multiple datasets in separate tabs
    dataviewer() # Opens the "Import Dataset" tab (foreground mode - console will be busy)

    # Run in foreground to enable the "Import Dataset" tab alongside 'mtcars'
    dataviewer(mtcars, background = FALSE)

    # Stop background process
    id <- dataviewer(mtcars, iris)
    stop_dataviewer(id)
}

}
\seealso{
For more information about the features of dataviewer, please refer to the \href{https://madhankumarnagaraji.github.io/dataviewR/articles/Introduction-to-dataviewR.html}{documentation}.
}
