% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write.R
\name{write_define}
\alias{write_define}
\title{Creates a define XML document}
\usage{
write_define(
  path,
  dir,
  type = "sdtm",
  ver = NULL,
  check = TRUE,
  html = TRUE,
  view = TRUE,
  report_type = "PDF",
  end_char = ""
)
}
\arguments{
\item{path}{The path to the metadata file.  Currently only Excel metadata
files are supported.  Other metadata sources may be added if there is sufficient
interest.}

\item{dir}{The output directory to create the define.xml and associated files.
If the directory does not exist, the function will attempt to create it.}

\item{type}{The type of define.xml to create.  Valid values are
"sdtm" and "adam".  Default is "sdtm".}

\item{ver}{The version of the define XML to produce. Currently only
version "2.0.0" is supported.}

\item{check}{Whether or not to perform consistency checks.  If so,
a check report will be produced in the output directory. Valid values
are TRUE and FALSE.  Default is TRUE.}

\item{html}{Whether or not to produce the HTML output associated with the
define.xml.  Valid values are TRUE and FALSE.  Default is TRUE.}

\item{view}{Whether or not to show the check report in the viewer.  Valid
values are TRUE and FALSE.  Default is TRUE.}

\item{report_type}{The output type of the check report, if requested.
Valid values are "TXT", "RTF", "PDF", "HTML" and "DOCX".  Default is
"PDF".}

\item{end_char}{The end character to use on computational method blocks.
These blocks often contain code samples that include line feeds or other
line ending characters.  This parameter can be used to control how
these characters are emitted to the XML parser.  Default is an empty
string ("").  If the line feeds in your computational methods are not working,
trying using a return ("\\r") or new line ("\\n").}
}
\value{
The define.xml file and any associated files will be written
to the directory specified on the \code{dir} parameter.
}
\description{
The \code{write_define} function inputs an SDTM or ADAM
metadata file and outputs a define.xml and associated files to a specified
directory. Possible associated files are the HTML transformation of
the define.xml and a check report. By default, the check report will
also be shown in the viewer.
}
\details{
The define.xml document is used by the FDA (and others) to review
study data. All datasets used in the study are listed, along with
variable and value metadata, where clauses, and more.  The define.xml
can be used along with an XSLT style sheet to transform the XML into
an HTML report.  This HTML report has links that allow you to easily
navigate the data structures.

The \code{write_define} function
creates both the define XML and the define HTML. The \code{path}
parameter identifies the location of the Excel metadata, and the
\code{dir} parameter specifies an output directory.  You can create
both SDTM and ADAM metadata by passing the appropriate value on the
\code{type} parameter.

Importantly, the function also produces a check report.  This report
will compare the define.xml file against the XSD schema supplied by
CDISC.  Any discrepancies will be written to the check report.  By default,
the check report is also shown in the viewer, and returned as a vector of
strings by the function.  This discrepancy list allows you to verify
that the metadata has been filled out correctly.

For instance, the
conformance check will ensure that each object ID (OID) is unique within
the document.  Any non-unique IDs will be identified and written to the
check report. The check report may therefore be used iteratively to
fix the metadata.

Any errors that prevent proper functioning of the procedure will stop
execution, and be displayed in the console.  All other errors and
warnings will be sent to the check report, and will not stop execution.

Note that the \code{check} parameter can be used to turn off the
conformance check mechanism, and just create the XML.

The XSD schema and XSLT transformation documents were created by CDISC,
and are included in the \strong{defineR} package for convenience. To
specify another version of the documents, use the options "defineR.xsd"
and "defineR.xslt".  For example:
\code{options("defineR.xsd" = "c:/myproject/define2-1-0.xsd")}.
}
\examples{
\donttest{
# Get temp directory
tmp <- tempdir()

# Create demo metadata
pth <- write_metadata(tmp, demo = TRUE)

# Generate define files
res <- write_define(pth, tmp, view = FALSE)

# View check results
res
# NULL

# View XML
# file.show(file.path(tmp, "define.sdtm.xml"))

# View check report
# file.show(file.path(tmp, "check.sdtm.pdf"))

# View HTML
# file.show(file.path(tmp, "define.sdtm.html"))
}
}
\seealso{
\code{\link{write_metadata}} to create a metadata template.
}
