% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sum_stat_p.R
\name{sum_stat_p}
\alias{sum_stat_p}
\title{Create a Summary Table With P-Values for Group Comparisons}
\arguments{
\item{data}{A data frame or tibble containing variables to summarise.}

\item{by}{A string specifying the grouping variable name. Must be a column in \code{data}.}

\item{statistic}{A string specifying summary style for continuous variables:
\itemize{
\item \code{"mean_sd"}: Mean (SD)
\item \code{"med_iqr"}: Median (IQR)
}}

\item{test_type}{Optionally force a specific test. Choices:
\itemize{
\item \code{"auto"} \emph{(default)} — automatically selects appropriate tests
\item \code{"chisq"}, \code{"fisher"} for categorical variables
\item \code{"t.test"}, \code{"wilcox"} for 2-group continuous comparisons
\item \code{"anova"}, \code{"kruskal"} for >2-group continuous comparisons
}}
}
\value{
A \code{flextable} object containing the summary table with p-values and
footer notes describing summary statistics and tests used.
}
\description{
\code{sum_stat_p()} generates a descriptive summary table for both categorical and
continuous variables stratified by a grouping variable. It automatically
computes appropriate statistical tests (Chi-square, Fisher's exact, t-test,
Wilcoxon, ANOVA, or Kruskal–Wallis) based on data type and distribution
characteristics. The output is formatted as a \code{flextable} with footnotes
indicating the summary statistics used and the tests applied.
}
\examples{
# Load built-in dataset
data(CO2)

# Example 1: Auto test selection, median/IQR summary
sum_stat_p(CO2, by = "Type", statistic = "med_iqr")

# Example 2: Force Wilcoxon test for continuous variables
sum_stat_p(CO2, by = "Type", statistic = "med_iqr", test_type = "wilcox")

# Example 3: Mean/SD with automatic test choice
sum_stat_p(CO2, by = "Treatment", statistic = "mean_sd")
}
