% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boxplots.R
\name{boxplot_subject}
\alias{boxplot_subject}
\title{Plot interactive boxplots of EEG amplitude across subjects}
\usage{
boxplot_subject(
  data,
  amplitude = "signal",
  subject = NULL,
  time_lim,
  title_label = NULL,
  use_latex = TRUE
)
}
\arguments{
\item{data}{A data frame or a database table with EEG dataset. Required columns: \code{subject}, \code{sensor}, \code{time} and the column with EEG amplitude named as in \code{amplitude} parameter.}

\item{amplitude}{A character specifying the name of the column from input data with an EEG amplitude values. Default is \code{"signal"}.}

\item{subject}{A vector with IDs of subjects to plot. If missing, boxplots are drawn for all avaliable subjects in \code{data}.}

\item{time_lim}{A numeric vector with time range to plot.}

\item{title_label}{A character string specifying the title of the plot. Defaults to \code{NULL} for plot without title.}

\item{use_latex}{A logical value indicating whether to use LaTeX formatting for the y-axis title. The default is \code{TRUE}.}
}
\value{
A \code{plotly} object with boxplots of EEG amplitude across subjects.
}
\description{
Function for plotting interactive boxplots of EEG amplitude across subjects for a single epoch and channel, within a specified time interval. The function assumes data from a single epoch and a single sensor.
The interactive plotly output enables to easily determine the subjects with outlier amplitude and also allows to easily edit the image layout.
}
\details{
The input data frame or database table must contain at least following columns:
\code{subject} - a column with subject IDs,
\code{time} - a column with time point numbers,
and a column with measured EEG signal values (or their averages) called as in \code{amplitude}.

Note: The function assumes that subject IDs are unique across the entire dataset. Using the same subject IDs in multiple groups may result in incorrect or misleading visualizations.
}
\examples{
# Interactive boxplots of signal from channel E34 in epoch 1
# for both subjects in chosen time points
## Note: it has no statistical sense to make boxplot from only 2 observations, but
## larger example dataset is not possible due to size limit of the package
epochdata |>
pick_data(sensor_rg = "E34", epoch_rg = 1) |>
boxplot_subject(amplitude = "signal", time_lim = c(10:20),
title_label = "Sensor E34, epoch 1")

}
\seealso{
\code{\link{boxplot_epoch}}
}
