% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ModelOfDiagnostic.r
\name{ModelOfDiagnostic}
\alias{ModelOfDiagnostic}
\title{Model of Diagnostic Marker Based on All Individual State Counts}
\usage{
ModelOfDiagnostic(
  I4,
  OriginalHI,
  epsilon = 0.99,
  verbose = FALSE,
  folder = "likelihood",
  ...
)
}
\arguments{
\item{I4}{a matrix or data.frame with 4 numeric columns
representing character state
counts for missing data, homozygots for allele 1, heterozygots, and
homozygots for allele 2. Individuals in rows.}

\item{OriginalHI}{numeric vector of length equal to number of rows in \code{I4},
representing hybrid indices of individuals.}

\item{epsilon}{A numeric, specifying how much the hypothetical diagnostic markers should
contribute to the likelihood calculations. Must be in \code{[0,1)}, keeping
tolerance setting of the \code{R} session in mind.}

\item{verbose}{Logical or character with path to directory where run diagnostics will
be saved.}

\item{folder}{character specifying path to a folder for the verbose output.}

\item{...}{additional arguments.}
}
\value{
Matrix with dimensions of I4.
}
\description{
Estimates a diagnostic marker for the state counts of all genomic markers for all
individuals. Using the hypothetical, diagnostic marker, calculates individual state
counts with respect to their weighted similarity to the diagnostic marker states.
}
\details{
The \code{OriginalHI} can be calculated with \code{\link{pHetErrOnStateCount}}.
}
\seealso{
\code{\link{diem}} for utilising the model to determine appropriate marker
polarisation in estimating barriers to geneflow.
}
