% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/options.R
\name{doFuture.options}
\alias{doFuture.options}
\title{Options used by the doFuture adapter}
\description{
Below are all \R options specific to the \pkg{doFuture} package.
For options controlling futures in general, see
\link[future:zzz-future.options]{the options} for the \pkg{future} package.\cr
\cr
\emph{WARNING: Note that the names and the default values of
these options may change in future versions of the package.
Please use with care until further notice.}
}
\details{
\describe{
\item{\option{doFuture.foreach.export}:}{
Specifies to what extent the \code{.export} argument of \code{\link[foreach:foreach]{foreach::foreach()}}, paired
with \code{\link[foreach:\%dopar\%]{\%dopar\%}}, should be respected or
if globals should be automatically identified. This is only for
\verb{\%dopar\%} -- \code{\link{\%dofuture\%}} does not support \code{.export} and \code{.noexport}.

If \code{".export"}, then the globals specified by the \code{.export}
argument will be used "as is".

If \code{".export-and-automatic"}, then globals specified by
\code{.export} as well as those automatically identified are used.

The \code{".export-and-automatic-with-warning"} is the same as
\code{".export-and-automatic"}, but produces a warning if \code{.export}
lacks some of the globals that the automatic identification locates,
which could be helpful feedback to developers using \code{\link[foreach:foreach]{foreach::foreach()}} with
\verb{\%dopar\%} -- also when using adapters such as \strong{doParallel}.

(Default: \code{".export-and-automatic"})
}

\item{\option{doFuture.debug}:}{If \code{TRUE}, extensive debug messages are
generated. (Default: \code{FALSE})}
}
}
\section{Environment variables that set R options}{

All of the above \R \option{doFuture.*} options can be set by
corresponding environment variable \env{R_DOFUTURE_*} \emph{when the
\pkg{doFuture} package is loaded}.
For example, if \code{R_DOFUTURE_DEBUG=TRUE}, then option
\option{doFuture.debug} is set to \code{TRUE} (logical).
}

\keyword{internal}
