% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reframe.R
\name{reframe}
\alias{reframe}
\title{Transform each group to an arbitrary number of rows}
\usage{
reframe(.data, ..., .by = NULL)
}
\arguments{
\item{.data}{A data frame, data frame extension (e.g. a tibble), or a
lazy data frame (e.g. from dbplyr or dtplyr). See \emph{Methods}, below, for
more details.}

\item{...}{<\code{\link[rlang:args_data_masking]{data-masking}}>

Name-value pairs of functions. The name will be the name of the variable in
the result. The value can be a vector of any length.

Unnamed data frame values add multiple columns from a single expression.}

\item{.by}{<\code{\link[=dplyr_tidy_select]{tidy-select}}> Optionally, a selection of columns to
group by for just this operation, functioning as an alternative to \code{\link[=group_by]{group_by()}}. For
details and examples, see \link[=dplyr_by]{?dplyr_by}.}
}
\value{
If \code{.data} is a tibble, a tibble. Otherwise, a data.frame.
\itemize{
\item The rows originate from the underlying grouping keys.
\item The columns are a combination of the grouping keys and the
expressions that you provide.
\item The output is always ungrouped.
\item Data frame attributes are \strong{not} preserved, because \code{reframe()}
fundamentally creates a new data frame.
}
}
\description{
While \code{\link[=summarise]{summarise()}} requires that each argument returns a single value, and
\code{\link[=mutate]{mutate()}} requires that each argument returns the same number of rows as the
input, \code{reframe()} is a more general workhorse with no requirements on the
number of rows returned per group.

\code{reframe()} creates a new data frame by applying functions to columns of an
existing data frame. It is most similar to \code{summarise()}, with two big
differences:
\itemize{
\item \code{reframe()} can return an arbitrary number of rows per group, while
\code{summarise()} reduces each group down to a single row.
\item \code{reframe()} always returns an ungrouped data frame, while \code{summarise()}
might return a grouped or rowwise data frame, depending on the scenario.
}

We expect that you'll use \code{summarise()} much more often than \code{reframe()}, but
\code{reframe()} can be particularly helpful when you need to apply a complex
function that doesn't return a single summary value.
}
\section{Connection to tibble}{

\code{reframe()} is theoretically connected to two functions in tibble,
\code{\link[tibble:enframe]{tibble::enframe()}} and \code{\link[tibble:enframe]{tibble::deframe()}}:
\itemize{
\item \code{enframe()}: vector -> data frame
\item \code{deframe()}: data frame -> vector
\item \code{reframe()}: data frame -> data frame
}
}

\section{Methods}{

This function is a \strong{generic}, which means that packages can provide
implementations (methods) for other classes. See the documentation of
individual methods for extra arguments and differences in behaviour.

The following methods are currently available in loaded packages:
\Sexpr[stage=render,results=rd]{dplyr:::methods_rd("reframe")}.
}

\examples{
table <- c("a", "b", "d", "f")

df <- tibble(
  g = c(1, 1, 1, 2, 2, 2, 2),
  x = c("e", "a", "b", "c", "f", "d", "a")
)

# `reframe()` allows you to apply functions that return
# an arbitrary number of rows
df |>
  reframe(x = intersect(x, table))

# Functions are applied per group, and each group can return a
# different number of rows.
df |>
  reframe(x = intersect(x, table), .by = g)

# The output is always ungrouped, even when using `group_by()`
df |>
  group_by(g) |>
  reframe(x = intersect(x, table))

# You can add multiple columns at once using a single expression by returning
# a data frame.
quantile_df <- function(x, probs = c(0.25, 0.5, 0.75)) {
  tibble(
    val = quantile(x, probs, na.rm = TRUE),
    quant = probs
  )
}

x <- c(10, 15, 18, 12)
quantile_df(x)

starwars |>
  reframe(quantile_df(height))

starwars |>
  reframe(quantile_df(height), .by = homeworld)

starwars |>
  reframe(
    across(c(height, mass), quantile_df, .unpack = TRUE),
    .by = homeworld
  )
}
\seealso{
Other single table verbs: 
\code{\link{arrange}()},
\code{\link{filter}()},
\code{\link{mutate}()},
\code{\link{rename}()},
\code{\link{select}()},
\code{\link{slice}()},
\code{\link{summarise}()}
}
\concept{single table verbs}
