% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rem_logit_deprecatedV100.R
\name{estimateREM}
\alias{estimateREM}
\title{Fit a Relational Event Model (REM) to Event Sequence Data}
\usage{
estimateREM(
  formula,
  event.cluster,
  data,
  ordinal = TRUE,
  multiple.events = FALSE,
  newton.rhapson = TRUE,
  optim.method = "BFGS",
  optim.control = list(),
  tolerance = 1e-09,
  maxit = 20,
  starting.beta = NULL,
  ...
)
}
\arguments{
\item{formula}{A formula object with the dependent variable on the left hand side of
~ and the covariates on the right hand side. This is the same argument found in \code{\link[stats]{lm}} and \code{\link[stats]{glm}}.}

\item{event.cluster}{An integer or factor vector that groups each observed event with its corresponding control (null) events.
This vector defines the strata in the event sequence, ensuring that each stratum contains one observed event and its associated
null alternatives. It is used to structure the likelihood by stratifying events based on their occurrence in time.}

\item{data}{The data.frame that contains the variable included in the formula argument.}

\item{ordinal}{TRUE/FALSE. Currently, this function supports only the estimation of ordinal timing relational event models
(see Butts 2008). Future versions of the package will include estimation options for interval timing
relational event models. At this time, this argument is preset to TRUE and should not be modified by the user.}

\item{multiple.events}{TRUE/FALSE. Currently, this function assumes that only one event occurs per
event cluster (i.e., time point). Future versions of the package will include estimation options for
multiple events per time point, commonly referred to as tied events, via the Breslow approximation
technique (see Box-Steffensmeier and Jones 2004). At this moment, this argument is preset to FALSE
and should not be modified by the user.}

\item{newton.rhapson}{TRUE/FALSE. TRUE indicates an internal Newton-Rhapson iteration procedure with line searching is used to
find the set of maximum likelihood estimates. FALSE indicates that the log likelihood function will be optimized via the
\code{\link{optim}} function. The function defaults to TRUE.}

\item{optim.method}{If newton.rhapson is FALSE, what optim method should be used in conjunction with the \code{\link{optim}} function. Defaults
to "BFGS". See the \code{\link{optim}} function for the set of options.}

\item{optim.control}{If newton.rhapson is FALSE, a list of control to be used in the \code{\link{optim}} function. See the \code{\link{optim}} function for the set of controls.}

\item{tolerance}{If newton.rhapson is TRUE, the stopping criterion for the absolute difference in the log likelihoods for each Newton-Rhapson iteration.
The optimization procedure stops when the absolute change in the log likelihoods is less than \code{tolerance} (see Greene 2003).}

\item{maxit}{If newton.rhapson is TRUE, the maximum number of iterations for the Newton-Rhapson optimization procedure (see Greene 2003).}

\item{starting.beta}{A numeric vector that represents the starting parameter estimates for the Newton-Rhapson optimization procedure. This may be a beneficial argument
if the optimization procedure fails, since the Newton-Rhapson optimization procedure is sensitive to starting values. Preset to NULL.}

\item{...}{Additional arguments.}
}
\value{
An object of class "dream" as a list containing the following components:
\describe{
\item{optimization.method}{The optimzation method used to find the parameters..}
\item{converged}{TRUE/FALSE. TRUE indicates that the REM converged.}
\item{loglikelihood.null}{The log likelihood of the null model (i.e., the model where the parameters are assumed to be 0).}
\item{loglikelihood.full}{The log likelihood of the estimated model.}
\item{chi.stat}{The chi-statistic of the likelihood ratio test.}
\item{loglikelihood.test}{The p-value of the likelihood ratio test.}
\item{df.null}{The degrees of freedom of the null model.}
\item{df.full}{The degrees of freedom of the full model.}
\item{parameters}{The MLE parameter estimates.}
\item{hessian}{The estimated hessian matrix.}
\item{gradient}{The estimated gradient vector.}
\item{se.parameter}{The standard errors of the MLE parameter estimates.}
\item{covariance.mat}{The estimated variance-covariance matrix.}
\item{z.values}{The z-scores for the MLE parameter estimates.}
\item{p.values}{The p-values for the MLE parameter estimates.}
\item{AIC}{The AIC of the estimated REM.}
\item{BIC}{The BIC of the estimated REM.}
\item{n.events}{The number of observed events in the relational event sequence.}
\item{null.events}{The number of control events in the relational event sequence.}
\item{newton.iterations}{The number of Newton-Rhapson iterations.}
\item{search.algo}{A data.frame object that contains the Newton-Rhapson searching algorithm results.}
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

\code{estimateREM()} has been deprecated starting on version 1.0.0 of the \code{dream} package. Please use the \code{estimate_rem_logit()} function and see the \code{NEWS.md} file for more details.

This function estimates the ordinal timing relational event model by maximizing the
likelihood function given by Butts (2008) via maximum likelihood estimation. A nice outcome
is that the ordinal timing relational event model is equivalent to the conditional logistic
regression (see Greene 2003; for R functions, see \code{\link[survival]{clogit}}). In
addition, based on this outcome and the structure of the data, this function can estimate
the Cox proportional hazards model (see Box-Steffensmeier and Jones 2004; for R functions, see \code{\link[survival]{coxph}})
given that the likelihood functions are equivalent. An important assumption this model
makes is that only one event occurs at each time point. If this is unfeasible for
the user's specific dataset, we encourage the user to see the \code{\link[survival]{clogit}}
function for the Breslow approximation technique (Box-Steffensmeier and Jones 2004). Future
versions of the package will include options for interval timing relational event
models and tied event data (e.g., multiple events at one time point).
}
\details{
This function maximizes the ordinal timing relational event model likelihood
function provided in the seminal REM paper by Butts (2008). The likelihood function
is:
\deqn{L(E|\beta) = \prod_{i=1}^{|E|} \frac{\lambda_{e_i}}{\sum_{e' \in RS_{e_i}} \lambda_{e'}}}
where, following Butts (2008) and Duxbury (2020), \eqn{E} is the relational event sequence,
\eqn{\lambda_{e_i}} is the hazard rate for event \emph{i}, which is formulated to be equal to
\eqn{exp(\beta^{T}z(x,Y))}, that is, the linear combination of user-specific covariates, \eqn{z(x,Y)}, and associated
REM parameters, \eqn{\beta}. Following Duxbury (2020), \eqn{z(x,Y)} is a mapping
function that represents the endogenous network statistics computed on the network
of past events,\eqn{x}, and exogenous covariates, \eqn{Y}. The user provides these
covariates via the \code{formula} argument.

This function provides two numerical optimization techniques to find the maximum
likelihood estimates for the associated parameters. First, this function allows
the user to use the \code{\link{optim}} function to find the associated parameters
based on the above likelihood function. Secondly, and by default, this function
employs a Newton-Rhapson iteration algorithm with line-searching to find
the unknown parameters (see Greene 2003 for a discussion of this algorithm). If desired, the user can
provide the initial searching values for both algorithms with the \code{starting.beta} argument.

It's important to note that the modeling concerns of the conditional logistic regression apply to the
ordinal timing relational event model, such as no within-sequence fixed effects, that is,
a variable that does not vary within event cluster (i.e., a variable that is the
same for both the null and observed events). The function internally checks for
this and provides the user with a warning if any requested effects has no total within-event
variance. Moreover, any observed events that have no associated control events are
removed from the analysis as they provide no information to the log likelihood (see Greene 2003). The function
removes these events from the sequence prior to estimation.
}
\examples{
#Creating a psuedo one-mode relational event sequence with ordinal timing
relational.seq <- simulateRESeq(n_actors = 8,
                               n_events = 50,
                               inertia = TRUE,
                               inertia_p = 0.10,
                               sender_outdegree = TRUE,
                               sender_outdegree_p = 0.05)

#Creating a post-processing event sequence for the above relational sequence
post.processing <- processOMEventSeq(data = relational.seq,
                                    time = relational.seq$eventID,
                                    eventID = relational.seq$eventID,
                                    sender = relational.seq$sender,
                                    receiver = relational.seq$target,
                                    n_controls = 5)

#Computing the sender-outdegree statistic for the above post-processing
#one-mode relational event sequence
post.processing$sender.outdegree <- computeSenderOutdegree(
                                   observed_time = relational.seq$eventID,
                                   observed_sender = relational.seq$sender,
                                   processed_time = post.processing$time,
                                   processed_sender = post.processing$sender,
                                   counts = TRUE)

#Computing the inertia/repetition statistic for the above post-processing
#one-mode relational event sequence
post.processing$inertia <- computeRepetition(
                          observed_time = relational.seq$eventID,
                          observed_sender = relational.seq$sender,
                          observed_receiver = relational.seq$target,
                          processed_time = post.processing$time,
                          processed_sender = post.processing$sender,
                          processed_receiver = post.processing$receiver,
                          counts = TRUE)

#Fitting a (ordinal) relational event model to the above one-mode relational
#event sequence
rem <- estimateREM(observed~sender.outdegree+inertia,
                  event.cluster = post.processing$time,
                  data=post.processing)
summary(rem) #summary of the relational event model

#Fitting a (ordinal) relational event model to the above one-mode relational
#event sequence via the optim function
rem1 <- estimateREM(observed~sender.outdegree+inertia,
                  event.cluster = post.processing$time,
                  data=post.processing,
                  newton.rhapson=FALSE) #use the optim function
summary(rem1) #summary of the relational event model
}
\references{
Box-Steffensmeier, Janet and Bradford S. Jones. 2004. \emph{Event History Modeling: A Guide for Social Scientists}. Cambridge University Press.

Butts, Carter T. 2008. "A Relational Event Framework for Social Action." \emph{Sociological Methodology} 38(1): 155-200.

Duxbury, Scott. 2020. \emph{Longitudinal Network Models}. Sage University Press. Quantitative Applications in
the Social Sciences: 192.

Greene, William H. 2003. \emph{Econometric Analysis}. Fifth Edition. Prentice Hall Press.
}
\author{
Kevin A. Carson \href{mailto:kacarson@arizona.edu}{kacarson@arizona.edu}, Diego F. Leal \href{mailto:dflc@arizona.edu}{dflc@arizona.edu}
}
