% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getConstraintTests.R
\name{getConstraintTests}
\alias{getConstraintTests}
\title{A function that performs a score test for relaxing each invariance equality constraint between partners in a given dyadic SEM model.}
\usage{
getConstraintTests(constrainFit, filterSig = FALSE)
}
\arguments{
\item{constrainFit}{fitted lavaan model with dyadic invariance equality constraints}

\item{filterSig}{logical indicating whether to filter for significant constraints (default is FALSE)}
}
\value{
a data frame with rows of equality constraints (now with readable param labels) and test statistic, df, and p for whether constraint worsens model fit
}
\description{
A function that performs a score test for relaxing each invariance equality constraint between partners in a given dyadic SEM model.
}
\examples{
dvn <- scrapeVarCross(dat = commitmentM, x_order = "sip", x_stem = "sat.g",
x_delim2="_", distinguish_1="f", distinguish_2="m")

sat.resids.script <- scriptCor(dvn, lvname = "Sat",
constr_dy_meas = c("loadings", "intercepts", "residuals"),
constr_dy_struct = "none")

sat.resids.mod <- lavaan::cfa(sat.resids.script, data = commitmentM, std.lv = FALSE,
auto.fix.first= FALSE, meanstructure = TRUE)

getConstraintTests(sat.resids.mod)
}
