% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_posterior_parameters.R
\name{plot_posterior_parameters}
\alias{plot_posterior_parameters}
\alias{plot_posterior_parameters.abc}
\title{Plot parameter posterior distributions}
\usage{
plot_posterior_parameters(data, ...)

\method{plot_posterior_parameters}{abc}(data, abc_input = NULL, ...)
}
\arguments{
\item{data}{An \code{abc} object containing posterior samples in
\code{adj.values} or \code{unadj.values}.}

\item{...}{Additional arguments:
\describe{
  \item{n_rows}{Integer; number of rows in the plot grid (default: 2)}
  \item{n_cols}{Integer; number of columns in the plot grid (default: 2)}
  \item{interactive}{Logical; whether to pause between pages and wait for input}
}}

\item{abc_input}{Optional abc_input object containing prior samples for comparison.
If provided, prior distributions are shown as red histograms and posterior
distributions as blue density curves.}
}
\value{
Invisibly returns `NULL`. Called for its side effect of producing plots.
}
\description{
Plotting posterior distributions (and optionally prior distributions) from ABC results.
}
\details{
The plots use the following visual encoding:
\itemize{
  \item Posterior distributions: blue density curves
  \item Prior distributions (if provided): red histograms with transparency
}
}
\examples{
# Load ABC output from saved file
abc_file <- system.file(
  "extdata", "rdm_minimal", "abc", "abc_rejection_model.rds",
  package = "eam"
)
abc_rejection_model <- readRDS(abc_file)

# Load ABC input for prior comparison
abc_input_file <- system.file(
  "extdata", "rdm_minimal", "abc", "abc_input.rds",
  package = "eam"
)
abc_input <- readRDS(abc_input_file)

# Plot posterior distributions with prior comparison
plot_posterior_parameters(abc_rejection_model, abc_input)

}
\seealso{
\code{\link{plot_posterior_parameters.abc}}
}
