% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-fable.R
\name{report.ESN}
\alias{report.ESN}
\title{Provide a detailed summary of the trained ESN model}
\usage{
\method{report}{ESN}(object, ...)
}
\arguments{
\item{object}{An object of class \code{mdl_df}, containing an ESN model.}

\item{...}{Currently not in use.}
}
\value{
Print detailed model summary.
}
\description{
Provide a detailed summary of the trained ESN model. The 
   function is a wrapper for \code{summary.esn()}.
}
\examples{
library(tsibble)
library(fable)
AirPassengers \%>\%
as_tsibble() \%>\%
model("ESN" = ESN(value)) \%>\%
report()

}
\seealso{
Other tidy functions: 
\code{\link{ESN}()},
\code{\link{filter_esn}()},
\code{\link{fitted.ESN}()},
\code{\link{forecast.ESN}()},
\code{\link{glance.ESN}()},
\code{\link{model_sum.ESN}()},
\code{\link{reservoir}()},
\code{\link{residuals.ESN}()},
\code{\link{tidy.ESN}()}
}
\concept{tidy functions}
