% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{remove_higher_cocktails}
\alias{remove_higher_cocktails}
\title{Filter out drug cocktails with high-level ATC classifications}
\usage{
remove_higher_cocktails(
  solutions,
  ATC_name,
  ATC_length,
  find_last_occurence = TRUE,
  max_height_ratio = 0.5
)
}
\arguments{
\item{solutions}{A \code{Rcpp::DataFrame} containing the results to filter. Must include columns: 
"score", "RR", "p_value", "n.patient.taking.C", "n.patient.taking.C.and.having.AE", and "Cocktail".}

\item{ATC_name}{A vector of strings containing the ATC codes/names used for mapping.}

\item{ATC_length}{An integer vector where each element represents the length (hierarchy level) 
of the corresponding ATC code in \code{ATC_name}.}

\item{find_last_occurence}{Logical. If \code{true} (default), the mapping logic will look for 
the last occurrence of a drug name in the reference list.}

\item{max_height_ratio}{A double (default 0.5) representing the maximum allowable proportion 
of high-level nodes (length <= 3) in a cocktail. Cocktails exceeding this ratio are removed.}
}
\value{
A \code{Rcpp::DataFrame} with the same columns as \code{solutions}, containing only 
  the cocktails that met the \code{max_height_ratio} criteria.
}
\description{
This function iterates through a collection of drug combinations (cocktails) and filters out 
those that have a ratio of "high-level" nodes (ATC codes with length <= 3) exceeding 
the specified threshold. This is useful for removing overly generic drug categories 
from results.
}
