% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_scc.R
\name{are_sufficient}
\alias{are_sufficient}
\title{Check if a certain set of component causes is suffcient}
\usage{
are_sufficient(scc, causes = NULL, type = c("status", "binary"))
}
\arguments{
\item{scc}{An object of class \code{epicmodel_scc}.}

\item{causes}{NULL (default) or a character vector containing IDs of a set of component causes. If NULL, prints a list of all available
component causes.}

\item{type}{Either "status" (default) or "binary". If "status", returns one of "always", "depends", "never". If "binary", returns TRUE or FALSE.}
}
\value{
For \verb{type = "binary}, returns TRUE if all component causes for at least one sufficient cause are in \code{causes} and FALSE otherwise. For
\code{type = status}, returns "always" if at least one sufficient cause with sufficiency status "always" is fulfilled. If not, returns "depends" if
at least one sufficient cause with sufficiency status "depends" or "depends (potential order implausibilities)" is fulfilled. If no sufficient
cause is fulfilled, returns "never".
}
\description{
Provide a SCC model and a set of component causes and evaluate if the provided set of causes fulfills any sufficient cause, i.e., is sufficient
for the outcome to occur based on the provided SCC model. Fulfilling a sufficient cause means that all component causes of a certain sufficient
cause are in the provided set of causes. Unknown causes are ignored by this function.
}
\details{
Depending on the value of \code{type}, the following values are possible:
\itemize{
\item \code{type = "status"}: If the provided set of \code{causes} contains all component causes of a sufficient cause with status "always", returns "always".
If the provided set of \code{causes} only fulfills sufficient cause with status "depends" or "depends (potential order implausibilities)", returns
"depends". If no sufficient causes are fulfilled, returns "never".
\item \code{type = "binary"}: If the returned status would have been "always" or "depends", TRUE is returned. If the returned status would have been
"never", returns FALSE.
}
}
\examples{
# Create some SCC model
steplist_checked <- check_steplist(steplist_rain)
scc_model <- create_scc(steplist_checked)

# Check sufficiency for a certain set of component causes
are_sufficient(scc_model, c("THENa1","THENa5"), type = "status")
are_sufficient(scc_model, c("THENa1","THENa5"), type = "binary")
}
