% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/probsens-legacy.R
\name{probsens_legacy}
\alias{probsens_legacy}
\title{Legacy version of \code{probsens()}.}
\usage{
probsens_legacy(
  case,
  exposed,
  type = c("exposure", "outcome"),
  reps = 1000,
  seca.parms = list(dist = c("constant", "uniform", "triangular", "trapezoidal",
    "logit-logistic", "logit-normal", "beta"), parms = NULL),
  seexp.parms = NULL,
  spca.parms = list(dist = c("constant", "uniform", "triangular", "trapezoidal",
    "logit-logistic", "logit-normal", "beta"), parms = NULL),
  spexp.parms = NULL,
  corr.se = NULL,
  corr.sp = NULL,
  discard = TRUE,
  alpha = 0.05
)
}
\arguments{
\item{case}{Outcome variable. If a variable, this variable is tabulated against.}

\item{exposed}{Exposure variable.}

\item{type}{Choice of correction for exposure or outcome misclassification.}

\item{reps}{Number of replications to run.}

\item{seca.parms}{List defining:
\enumerate{
\item The sensitivity of exposure classification among those with the outcome
(when \code{type = "exposure"}), or
\item The sensitivity of outcome classification among those with the exposure
(when \code{type = "outcome"}).
}
The first argument provides the probability distribution function (constant,
uniform, triangular, trapezoidal, logit-logistic, logit-normal, or beta) and
the second its parameters as a vector. Logit-logistic and logit-normal
distributions can be shifted by providing lower and upper bounds. Avoid
providing these values if a non-shifted distribution is desired.
\enumerate{
\item constant: constant value,
\item uniform: min, max,
\item triangular: lower limit, upper limit, mode,
\item trapezoidal: min, lower mode, upper mode, max,
\item logit-logistic: location, scale, lower bound shift, upper bound shift,
\item logit-normal: location, scale, lower bound shift, upper bound shift.
\item beta: alpha, beta.
}}

\item{seexp.parms}{List defining:
\enumerate{
\item The sensitivity of exposure classification among those without the
outcome (when \code{type = "exposure"}), or
\item The sensitivity of outcome classification among those without the
exposure (when \code{type = "outcome"}).
}}

\item{spca.parms}{List as above for \code{seca.parms} but for specificity.}

\item{spexp.parms}{List as above for \code{seexp.parms} but for specificity.}

\item{corr.se}{Correlation between case and non-case sensitivities.}

\item{corr.sp}{Correlation between case and non-case specificities.}

\item{discard}{A logical scalar. In case of negative adjusted count, should
the draws be discarded? If set to FALSE, negative counts are set to zero.}

\item{alpha}{Significance level.}
}
\value{
A list with elements:
\item{obs.data}{The analyzed 2 x 2 table from the observed data.}
\item{obs.measures}{A table of observed relative risk and odds ratio with
confidence intervals.}
\item{adj.measures}{A table of corrected relative risks and odds ratios.}
\item{sim.df}{Data frame of random parameters and computed values.}
\item{reps}{Number of replications.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#superseded}{\figure{lifecycle-superseded.svg}{options: alt='[Superseded]'}}}{\strong{[Superseded]}}

episensr 2.0.0 introduced breaking changes in probabilistic bias analyses by
(1) using the NORTA transformation to define a correlation between
distributions, and (2) sampling true prevalences and then sampling the
adjusted cell counts rather than just using the expected cell counts from a
simple quantitative bias analysis. This updated version should be preferred
and this legacy version will be deprecated in future versions. However, if
you need to quickly roll back to the previous calculations, this function
provides the previous interface. To make old code work as is, add the
following code to the top of your script:

\if{html}{\out{<div class="sourceCode">}}\preformatted{library(episensr)
probsens <- probsens_legacy
}\if{html}{\out{</div>}}
}
\examples{
# The data for this example come from:
# Greenland S., Salvan A., Wegman D.H., Hallock M.F., Smith T.J.
# A case-control study of cancer mortality at a transformer-assembly facility.
# Int Arch Occup Environ Health 1994; 66(1):49-54.
\dontrun{
set.seed(123)
# Exposure misclassification, non-differential
probsens_legacy(matrix(c(45, 94, 257, 945),
dimnames = list(c("BC+", "BC-"), c("Smoke+", "Smoke-")), nrow = 2, byrow = TRUE),
type = "exposure",
reps = 20000,
seca.parms = list("trapezoidal", c(.75, .85, .95, 1)),
spca.parms = list("trapezoidal", c(.75, .85, .95, 1)))

# Exposure misclassification, differential
probsens_legacy(matrix(c(45, 94, 257, 945),
dimnames = list(c("BC+", "BC-"), c("Smoke+", "Smoke-")), nrow = 2, byrow = TRUE),
type = "exposure",
reps = 20000,
seca.parms = list("trapezoidal", c(.75, .85, .95, 1)),
seexp.parms = list("trapezoidal", c(.7, .8, .9, .95)),
spca.parms = list("trapezoidal", c(.75, .85, .95, 1)),
spexp.parms = list("trapezoidal", c(.7, .8, .9, .95)),
corr.se = .8,
corr.sp = .8)

probsens_legacy(matrix(c(45, 94, 257, 945),
dimnames = list(c("BC+", "BC-"), c("Smoke+", "Smoke-")), nrow = 2, byrow = TRUE),
type = "exposure",
reps = 20000,
seca.parms = list("beta", c(908, 16)),
seexp.parms = list("beta", c(156, 56)),
spca.parms = list("beta", c(153, 6)),
spexp.parms = list("beta", c(205, 18)),
corr.se = .8,
corr.sp = .8)

probsens_legacy(matrix(c(338, 490, 17984, 32024),
dimnames = list(c("BC+", "BC-"), c("Smoke+", "Smoke-")), nrow = 2, byrow = TRUE),
type = "exposure",
reps = 1000,
seca.parms = list("trapezoidal", c(.8, .9, .9, 1)),
spca.parms = list("trapezoidal", c(.8, .9, .9, 1)))

# Disease misclassification
probsens_legacy(matrix(c(173, 602, 134, 663),
dimnames = list(c("BC+", "BC-"), c("Smoke+", "Smoke-")), nrow = 2, byrow = TRUE),
type = "outcome",
reps = 20000,
seca.parms = list("uniform", c(.8, 1)),
spca.parms = list("uniform", c(.8, 1)))

probsens_legacy(matrix(c(338, 490, 17984, 32024),
dimnames = list(c("BC+", "BC-"), c("Smoke+", "Smoke-")), nrow = 2, byrow = TRUE),
type = "outcome",
reps = 20000,
seca.parms = list("uniform", c(.2, .6)),
seexp.parms = list("uniform", c(.1, .5)),
spca.parms = list("uniform", c(.99, 1)),
spexp.parms = list("uniform", c(.99, 1)),
corr.se = .8,
corr.sp = .8)

probsens_legacy(matrix(c(173, 602, 134, 663),
dimnames = list(c("BC+", "BC-"), c("Smoke+", "Smoke-")), nrow = 2, byrow = TRUE),
type = "outcome",
reps = 20000,
seca.parms = list("beta", c(100, 5)),
seexp.parms = list("beta", c(110, 10)),
spca.parms = list("beta", c(120, 15)),
spexp.parms = list("beta", c(130, 30)),
corr.se = .8,
corr.sp = .8)
}
}
\references{
Lash, T.L., Fox, M.P, Fink, A.K., 2009 \emph{Applying Quantitative
Bias Analysis to Epidemiologic Data}, pp.117--150, Springer.
}
