% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gt_cfr.R
\name{add_ar}
\alias{add_ar}
\title{Add attack rate statistics to a gtsummary table}
\usage{
add_ar(
  gts_object,
  case_var,
  population = NULL,
  multiplier = 10^4,
  drop_tblsummary_stat = FALSE
)
}
\arguments{
\item{gts_object}{A gtsummary object created with functions such as
\code{gtsummary::tbl_summary()}}

\item{case_var}{A logical variable name in the data indicating case status
(e.g. \code{TRUE} for cases).}

\item{population}{Optional numeric vector giving the population size for
the denominator. If \code{NULL}, the population is inferred from the data.}

\item{multiplier}{Numeric multiplier used to scale the attack rate
(e.g. \code{1} = proportion, \code{100} = percent, \code{10^4} = per 10,000).}

\item{drop_tblsummary_stat}{Logical; if \code{TRUE}, removes the original
\code{tbl_summary} statistic column (default = \code{FALSE}).}
}
\value{
A modified gtsummary object with additional columns showing
the number of cases, population, attack rate, and 95\% confidence interval.
}
\description{
This function wraps \code{gtsummary::add_stat()} to calculate and display
\strong{attack rates} (cases per given population multiplier) with 95\% confidence
intervals, using the \code{epitabulate::attack_rate()} function internally.
}
