% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network.sign.R
\name{network.sign}
\alias{network.sign}
\title{Create Signed Network Object}
\usage{
network.sign(
  mat = NULL,
  pos.mat = NULL,
  neg.mat = NULL,
  directed = FALSE,
  loops = FALSE,
  matrix.type = c("adjacency", "edgelist"),
  vertex.names = NULL,
  vertex.attr = NULL,
  dual.sign = FALSE,
  timepoints = NULL,
  tie.breaker = c("zero", "positive", "negative", "first", "last"),
  ...
)
}
\arguments{
\item{mat}{(List of) signed adjacency matrices or edgelists. For dynamic networks, provide a list.
Adjacency matrices must contain only -1, 0, or 1. Edgelists must have three columns: "From", "To", and "Sign".}

\item{pos.mat}{Optional. Positive adjacency matrix or list of matrices.}

\item{neg.mat}{Optional. Negative adjacency matrix or list of matrices.
If provided, these are treated as two separate layers of the same network.}

\item{directed}{Logical; should edges be interpreted as directed? Defaults to FALSE.}

\item{loops}{Logical; should loops be allowed? Defaults to FALSE.}

\item{matrix.type}{Either "adjacency" or "edgelist".}

\item{vertex.names}{Optional. A vector or list of vertex names.}

\item{vertex.attr}{Optional. Additional vertex attributes.}

\item{dual.sign}{Logical. Allow positive and negative edges simultaneously between the same pair.}

\item{timepoints}{Optional. Pooling definition for dynamic networks.}

\item{tie.breaker}{How to resolve ties when pooling signed matrices.}

\item{...}{Additional arguments passed to `network::network`.}
}
\value{
A signed network of class `static.sign` or `dynamic.sign`.
}
\description{
Turn adjacency matrices or edgelists into static or dynamic signed networks.
}
