% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gof.ergm.R
\name{cdf-ergmTerm}
\alias{cdf-ergmTerm}
\alias{InitWtErgmTerm..gof.cdf}
\alias{InitWtErgmTerm.cdf}
\title{Empirical cumulative distribution function (unnormalized) of
the network's dyad values}
\usage{
# valued: cdf(min = NULL, max = NULL, by = NULL, margin = 0.1, nmax = 100)
}
\arguments{
\item{min, max, by}{range and step size for values at which to compute the CDF}

\item{margin, nmax}{autodetection of the range and step size; see Details.}
}
\description{
For every value \eqn{x} in \code{\link{seq}}\verb{(min, max, by)},
compute the number of dyads whose value is less than or equal
than \eqn{x}. If not given, the range is autodetected based on
the values in the LHS network, subject to adjustment via \code{margin}
and \code{nmax}.
}
\details{
If \code{min}, \code{max}, and/or \code{by} is missing, it is
automatically computed based on the LHS network's nonzero edge
values, specifically their range and resolution (smallest
observed difference between distinct values). Minimum and maximum
are taken from the minimal and the maximal edge values, and then
expanded by \code{margin} multiplied by their range, and rounded up to
the nearest multiple of the resolution. The step is set to the
smallest multiple of the resolution such that the total number of
statistics is no more than \code{nmax}.
}
\note{
This term is intended to be used in a \code{\link[=gof]{gof()}}'s \code{GOF}
formula, so its coefficient names are specially formatted to be
interpreted by \code{gof()} rather than for readability.
}
\seealso{
\ergmTerm{ergm}{atmost}{()}

\code{\link{ergmTerm}} for index of model terms currently visible to the package.

\Sexpr[results=rd,stage=render]{ergm:::.formatTermKeywords("ergmTerm", "cdf", "subsection")}
}
\concept{directed}
\concept{dyad-independent}
\concept{undirected}
