% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{simulate.ergmito}
\alias{simulate.ergmito}
\title{Draw samples from a fitted \code{ergmito} model}
\usage{
\method{simulate}{ergmito}(object, nsim = 1, seed = NULL, which_networks = 1L, theta = NULL, ...)
}
\arguments{
\item{object}{An object of class \link{ergmito}.}

\item{nsim}{Integer scalar. Number of samples to draw from the selected set
of networks.}

\item{seed}{See \link[stats:simulate]{stats::simulate}}

\item{which_networks}{Integer vector. Specifies what networks to sample from.
It must be within 1 and \code{nnets(object)}.}

\item{theta, ...}{Further arguments passed to \link{new_rergmito}.}
}
\description{
Draw samples from a fitted \code{ergmito} model
}
\examples{
data(fivenets)
fit <- ergmito(fivenets ~ edges + nodematch("female"))

# Drawing 200 samples from networks 1 and 3 from the model
ans <- simulate(fit, nsim = 200, which_networks = c(1, 3))
}
