% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{resumir}
\alias{resumir}
\title{Combina o resume data frames para resumen estadístico}
\usage{
resumir(..., nombres = NULL, exportar = FALSE, archivo = NULL)
}
\arguments{
\item{...}{Data frames a combinar o resumir.}

\item{nombres}{Vector de nombres opcionales para los objetos.}

\item{exportar}{Logical. Si TRUE, exporta a Excel.}

\item{archivo}{Nombre del archivo Excel; si NULL, se genera automáticamente.}
}
\value{
Data frame combinado si las columnas coinciden, o lista resumen si son distintas.
}
\description{
Combina o resume data frames para resumen estadístico
}
\examples{
\dontrun{
Ejemplo caso 1: resumir varios data frames con las mismas columnas
media <- estadistica::media(mtcars)
cuantiles <- estadistica::cuantiles(mtcars)

resultados <- resumir(media, cuantiles, exportar=TRUE)
resultados

Ejemplo caso 2: resumir varios data frames con distintas columnas
forma <- estadistica::medidas.forma(mtcars[c(1, 3, 4)])
resultados <- resumir(media, cuantiles, forma, exportar=TRUE)
resultados
}
}
