% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy.R
\name{ebc_tidy}
\alias{ebc_tidy}
\title{Tidy output for measures}
\usage{
ebc_tidy(
  detected,
  true,
  all,
  m = length(all),
  measures = c("TPR", "FPR", "FDR", "ACC", "F1")
)
}
\arguments{
\item{detected}{Vector of elements that are detected.}

\item{true}{Vector of element that are supposed to be detected.}

\item{all}{Vector of all elements.}

\item{m}{Total number of elements.}

\item{measures}{Desired measures of performance.}
}
\value{
A single-row data.frame with one column per
element in \code{measures}.
}
\description{
Construct a single row summary of the classifier.
}
\details{
See \code{\link{ebc_allmeasures}} for the available measures and
their descriptions.
}
\examples{
ebc_tidy(detected = c("A", "C", "D"), true = c("A", "B", "C"),
         all = LETTERS[1:6], measures = c("ACC", "FDR"))
}
\seealso{
\code{\link{ebc_TP}}, \code{\link{ebc_TPR}},
\code{\link{ebc_allmeasures}}
}
