% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{weight_target}
\alias{weight_target}
\title{Weight target variable}
\usage{
weight_target(data, target)
}
\arguments{
\item{data}{A dataset}

\item{target}{Target variable (0/1, TRUE/FALSE, yes/no)}
}
\value{
Weights for each observation (as a vector)
}
\description{
Create weights for the target variable in your dataset
so that are equal weights for target = 0 and target = 1.
Target must be 0/1, FALSE/TRUE ore no/yes
}
\examples{
iris$is_versicolor <- ifelse(iris$Species == "versicolor", 1, 0)
weights <- weight_target(iris, target = is_versicolor)
versicolor <- iris$is_versicolor
table(versicolor, weights)
}
