% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nonpar.datatable.R
\name{nonpar.datatable}
\alias{nonpar.datatable}
\title{Compact descriptive tables (APA-style) with global rank means}
\usage{
nonpar.datatable(formula, data, force_factors = TRUE)
}
\arguments{
\item{formula}{A formula of the form \code{y ~ A (+ B + ...)}.}

\item{data}{A \code{data.frame} containing \code{y} and the grouping factors.}

\item{force_factors}{Logical; coerce grouping variables to \code{factor}
(default \code{TRUE}).}
}
\value{
A base \code{data.frame} with columns:
\itemize{
\item \code{Effect} (character),
\item factor columns for all RHS factors (factors, possibly \code{NA} in some rows),
\item \code{count}, \code{mean}, \code{sd}, \code{median}, \code{q1}, \code{q3}, \code{IQR}, \code{mean_rank}.
}
The original call is attached as attribute \code{"call"}.
}
\description{
Produces descriptive statistics for all main effects and interaction cells
implied by the RHS of \code{formula}. Ranks are computed \emph{globally}
(across all observations) and cell-wise mean ranks are reported
(\strong{recommended} for interpreting rank-based factorial effects).
}
\details{
The function first subsets to complete cases on \code{y} and all RHS factors,
then computes global ranks of \code{y} (\code{ties.method = "average"}).
For each effect (every non-empty combination of factors up to full order),
it returns a row per cell with:
\code{count}, \code{mean}, \code{sd}, \code{median}, quartiles
(\code{q1}, \code{q3}), \code{IQR}, and \code{mean_rank}.
The column \code{Effect} identifies the effect (e.g., \code{"A"}, \code{"B"},
\code{"A:B"}). Missing factor columns for a given effect are added with
\code{NA} values but retain the proper factor levels for easy binding.
}
\examples{
data(mimicry, package = "factorH")

# One factor
nonpar.datatable(liking ~ condition, data = mimicry)

# Two factors: rows for gender, for condition, and for gender:condition
nonpar.datatable(liking ~ gender + condition, data = mimicry)

# Three factors: all mains + 2-way and 3-way cells
nonpar.datatable(liking ~ gender + condition + age_cat, data = mimicry)

}
