% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{FASSTER}
\alias{FASSTER}
\alias{fasster}
\title{Fast Additive Switching of Seasonality, Trend and Exogenous Regressors}
\usage{
FASSTER(formula, include = NULL, ...)
}
\arguments{
\item{formula}{An object of class "formula" (refer to 'Specials' section for usage)}

\item{include}{How many terms should be included to fit the model}

\item{...}{Not used}
}
\value{
Returns a mable containing the fitted FASSTER model.
}
\description{
Implements FASSTER
}
\details{
The fasster model extends commonly used state space models by introducing a switching component to the measurement equation.
This is implemented using a time-varying DLM with the switching behaviour encoded in the measurement matrix.
}
\section{Specials}{


The \emph{specials} define the model structure for \code{FASSTER}. The model can include
trend, seasonal, ARMA, and exogenous regressor components, with optional
switching behaviour controlled by grouping factors.

\subsection{trend}{
The \code{trend} special specifies polynomial trend components.
\preformatted{
trend(n, ...)
}

\tabular{ll}{
\code{n}   \tab The order of the polynomial trend. Use 1 for level, 2 for linear trend, etc. \cr
\code{...} \tab Additional arguments passed to \code{\link[dlm:dlmModPoly]{dlm::dlmModPoly()}}. Common arguments include \code{dV} (observation variance) and \code{dW} (state variance, can be a scalar or vector). \cr
}
}

\subsection{season}{
The \code{season} special specifies seasonal factors using indicator variables.
\preformatted{
season(period = NULL, ...)
}

\tabular{ll}{
\code{period} \tab The seasonal period. If \code{NULL}, automatically detected from the data (uses the smallest frequency). Can be a number or text like "1 year". \cr
\code{...}    \tab Additional arguments passed to \code{\link[dlm:dlmModSeas]{dlm::dlmModSeas()}}. Common arguments include \code{dV} and \code{dW}. \cr
}
}

\subsection{fourier}{
The \code{fourier} special specifies seasonal components using Fourier terms (trigonometric functions).
\preformatted{
fourier(period = NULL, K = floor(period/2), ...)
}

\tabular{ll}{
\code{period} \tab The seasonal period. If \code{NULL}, automatically detected from the data. \cr
\code{K}      \tab The number of Fourier terms (harmonics) to include. Maximum is \code{floor(period/2)}. More harmonics capture more complex seasonal patterns but increase model complexity. \cr
\code{...}    \tab Additional arguments passed to \code{\link[dlm:dlmModTrig]{dlm::dlmModTrig()}}. \cr
}
}

\subsection{ARMA}{
The \code{ARMA} special includes autoregressive moving average components.
\preformatted{
ARMA(...)
}

\tabular{ll}{
\code{...} \tab Arguments passed to \code{\link[dlm:dlmModARMA]{dlm::dlmModARMA()}}. Typically includes \code{ar} (vector of AR coefficients) and \code{ma} (vector of MA coefficients). \cr
}
}

\subsection{xreg}{
The \code{xreg} special includes exogenous regressors in the model.
\preformatted{
xreg(...)
}

\tabular{ll}{
\code{...} \tab Bare expressions for the exogenous regressors. These are evaluated in the context of the data, so you can use transformations like \code{log(x)} or interactions. \cr
}
}

\subsection{custom}{
The \code{custom} special allows you to specify custom DLM structures.
\preformatted{
custom(...)
}

\tabular{ll}{
\code{...} \tab Arguments passed to \code{\link[dlm:dlm]{dlm::dlm()}} to create a custom DLM component. \cr
}
}

\subsection{\verb{\%S\%} (Switching operator)}{
The \verb{\%S\%} operator creates switching models where different model structures
apply to different groups defined by a factor variable.
\preformatted{
group %S% model
}

\tabular{ll}{
\code{group} \tab A factor variable (or expression that evaluates to a factor) defining the groups. Each level of the factor will have its own version of the model component on the RHS. \cr
\code{spec} \tab The model specifications to replicate for each group. This can be any combination of \code{trend()}, \code{season()}, \code{fourier()}, etc. \cr
}

For example, \code{group \%S\% trend(1)} creates a separate level for each value of \code{group},
allowing the mean to switch between groups.
}

\subsection{\verb{\%?\%} (Conditional operator)}{
The \verb{\%?\%} operator creates conditional models where a component is only active
when a logical condition is TRUE.
\preformatted{
condition %?% model
}

\tabular{ll}{
\code{condition} \tab A logical variable or expression. The model component will only contribute when this is TRUE. \cr
\code{spec}     \tab The model component to conditionally include. \cr
}

For example, \code{(year > 2000) \%?\% trend(1)} includes a level component only for observations after 2000.
}
}

\section{Heuristic}{

The model parameters are estimated using the following heuristic:
\enumerate{
\item Filter the data using the specified model with non-zero state variances
\item Obtain smoothed states \eqn{(\theta^{(s)}t=\theta_t|D_T)} to approximate correct behaviour
\item The initial state parameters taken from the first smoothed state: \eqn{m_0=E(\theta^{(s)}_0)}, \eqn{C_0=Var(\theta^{(s)}_0)}
\item Obtain state noise variances from the smoothed variance of \eqn{w_t}: \eqn{W=Var(w^{(s)}_t)=Var(\theta^{(s)}_t-G\theta^{(s)}_{t-1})}
Obtain measurement noise variance from smoothed variance of \eqn{v_t}: \eqn{V=Var(v^{(s)}_t)=Var(y_t-F_t\theta^{(s)}_t)}
\item Repair restricted state variances for seasonal factors and ARMA terms
}
}

\examples{
# Basic model with trend and seasonality
cbind(mdeaths, fdeaths) |>
  as_tsibble(pivot_longer = FALSE) |>
  model(FASSTER(mdeaths ~ trend(1) + fourier(12)))

# Model with exogenous regressor
cbind(mdeaths, fdeaths) |>
  as_tsibble(pivot_longer = FALSE) |>
  model(FASSTER(mdeaths ~ fdeaths + trend(1) + fourier(12)))

# Switching model with different trends for different periods
cbind(mdeaths, fdeaths) |>
  as_tsibble(pivot_longer = FALSE) |>
  model(
    FASSTER(mdeaths ~ (lubridate::year(index) > 1977) \%S\% trend(1) + fourier(12))
  )

}
