% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expected-spectra.R
\name{svds.undirected_factor_model}
\alias{svds.undirected_factor_model}
\title{Compute the singular value decomposition of the expected adjacency matrix of an undirected factor model}
\usage{
\method{svds}{undirected_factor_model}(A, k = A$k, nu = k, nv = k, opts = list(), ...)
}
\arguments{
\item{A}{An \code{\link[=undirected_factor_model]{undirected_factor_model()}}.}

\item{k}{Desired rank of decomposition.}

\item{nu}{Number of left singular vectors to be computed. This must
be between 0 and \code{k}.}

\item{nv}{Number of right singular vectors to be computed. This must
be between 0 and \code{k}.}

\item{opts}{Control parameters related to the computing
algorithm. See \strong{Details} below.}

\item{...}{Unused, included only for consistency with generic signature.}
}
\description{
Compute the singular value decomposition of the expected adjacency matrix of an undirected factor model
}
\details{
The \code{opts} argument is a list that can supply any of the
following parameters:

\describe{
\item{\code{ncv}}{Number of Lanzcos basis vectors to use. More vectors
                  will result in faster convergence, but with greater
                  memory use. \code{ncv} must be satisfy
                  \eqn{k < ncv \le p}{k < ncv <= p} where
                  \code{p = min(m, n)}.
                  Default is \code{min(p, max(2*k+1, 20))}.}
\item{\code{tol}}{Precision parameter. Default is 1e-10.}
\item{\code{maxitr}}{Maximum number of iterations. Default is 1000.}
\item{\code{center}}{Either a logical value (\code{TRUE}/\code{FALSE}), or a numeric
                     vector of length \eqn{n}. If a vector \eqn{c} is supplied, then
                     SVD is computed on the matrix \eqn{A - 1c'}{A - 1 * c'},
                     in an implicit way without actually forming this matrix.
                     \code{center = TRUE} has the same effect as
                     \code{center = colMeans(A)}. Default is \code{FALSE}.}
\item{\code{scale}}{Either a logical value (\code{TRUE}/\code{FALSE}), or a numeric
                    vector of length \eqn{n}. If a vector \eqn{s} is supplied, then
                    SVD is computed on the matrix \eqn{(A - 1c')S}{(A - 1 * c')S},
                    where \eqn{c} is the centering vector and \eqn{S = diag(1/s)}.
                    If \code{scale = TRUE}, then the vector \eqn{s} is computed as
                    the column norm of \eqn{A - 1c'}{A - 1 * c'}.
                    Default is \code{FALSE}.}
}
}
