% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc-squintability.R
\name{sample_bases}
\alias{sample_bases}
\alias{print.basis_df}
\alias{tbl_sum.basis_df}
\alias{calc_smoothness}
\alias{print.smoothness_res}
\alias{tbl_sum.smoothness_res}
\alias{calc_squintability}
\alias{print.squintability_res}
\alias{tbl_sum.squintability_res}
\alias{fit_ks}
\alias{fit_nls}
\title{Function to calculate smoothness and squintability}
\usage{
sample_bases(
  idx,
  data = sine1000,
  n_basis = 300,
  parallel = FALSE,
  best = matrix(c(0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1), nrow = 6),
  min_proj_dist = NA,
  step_size = NA,
  seed = 123
)

\method{print}{basis_df}(x, width = NULL, ...)

\method{tbl_sum}{basis_df}(x)

calc_smoothness(
  basis_df,
  start_params = c(0.001, 0.5, 2, 2),
  other_gp_params = NULL,
  verbose = FALSE
)

\method{print}{smoothness_res}(x, width = NULL, ...)

\method{tbl_sum}{smoothness_res}(x)

calc_squintability(
  basis_df,
  method = c("ks", "nls"),
  scale = TRUE,
  bin_width = 0.005,
  other_params = NULL
)

\method{print}{squintability_res}(x, width = NULL, ...)

\method{tbl_sum}{squintability_res}(x)

fit_ks(basis_df, idx, other_params = NULL)

fit_nls(basis_df, other_params = NULL)
}
\arguments{
\item{idx}{character, the name of projection pursuit index function, e.g.
"holes"}

\item{data}{a matrix or data frame, the high dimensional data to be projected}

\item{n_basis}{numeric, the number of random bases to generate}

\item{parallel}{logic, whether to use parallel computing for calculating the index.
Recommend for the stringy index.}

\item{best}{a matrix, the theoretical/ empirical best projection matrix to
calculate the projection distance from the simulated random bases.}

\item{min_proj_dist}{only for squintability, the threshold for projection
distance for the random basis to be considered in sampling}

\item{step_size}{numeric, step size for interpolating from each random basis to
the best basis, recommend 0.005}

\item{seed}{numeric, seed for sampling random bases}

\item{x}{objects with specialised printing methods}

\item{width}{only used when \code{max.levels} is NULL, see above.}

\item{...}{further arguments passed to or from other methods.}

\item{basis_df}{the basis data frame returned from \code{sample_bases}}

\item{start_params}{list, the starting parameters for the Gaussian process
for smoothness}

\item{other_gp_params}{list, additional parameters to be passed to
[GpGp::fit_model()]
for calculating smoothness}

\item{verbose}{logical, whether to print optimisation progression when
fitting the Gaussian process}

\item{method}{either "ks" (kernel smoothing) or "nls" (non-linear least
square) for calculating squintability.}

\item{scale}{logic, whether to scale the index value to 0-1 in squintability}

\item{bin_width}{numeric, the bin width to average the index value
before fitting the kernel, recommend to set as the same as `step` parameter}

\item{other_params}{list additional parameters for fitting kernel smoothing
or non-linear least square, see [stats::ksmooth()] and
[stats::nls()] for details}
}
\description{
Function to calculate smoothness and squintability
}
\examples{
\dontrun{
library(GpGp)
library(fields)
library(tourr)
basis_smoothness <- sample_bases(idx = "holes")
calc_smoothness(basis_smoothness)
basis_squint <- sample_bases(idx = "holes", n_basis = 100, step_size = 0.01, min_proj_dist = 1.5)
calc_squintability(basis_squint, method = "ks", bin_width = 0.01)
}
}
