% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bkg_quasigeoid.R
\name{bkg_quasigeoid}
\alias{bkg_quasigeoid}
\title{Quasigeoid}
\usage{
bkg_quasigeoid(
  year = "latest",
  region = c("all", "coast", "no", "nw", "s", "w"),
  timeout = 120,
  update_cache = FALSE
)
}
\arguments{
\item{year}{Version year of the dataset. You can use \code{latest} to
retrieve the latest dataset version available on the BKG's geodata center.
Older versions can be browsed using the
\href{https://daten.gdz.bkg.bund.de/produkte/}{archive}.}

\item{region}{Subterritory of Germany. \code{"all"} returns the data for
all of Germany, \code{"coast"} returns only coastal regions and \code{"no"},
\code{"nw"}, \code{"s"} and \code{"w"} refer to cardinal directions. Defaults
to \code{"all"}.}

\item{timeout}{Timeout value for the data download passed to
\code{\link[httr2]{req_timeout}}. Adjust this if your internet connection is
slow or you are downloading larger datasets.}

\item{update_cache}{By default, downloaded files are cached in the
\code{tempdir()} directory of R. When downloading the same data again,
the data is not downloaded but instead taken from the cache. Sometimes
this can be not the desired behavior. If you want to overwrite the cache,
pass \code{TRUE}. Defaults to \code{FALSE}, i.e. always adopt the cache
if possible.}
}
\value{
A \code{\link[terra:rast]{SpatRaster}} containing normal heights
for the specified \code{region}. The data comes in EPSG:4258 and a
resolution of 30" x 45" (approximately 0.9 x 0.9 km).
}
\description{
Retrieves the "German Combined Quasigeoid", the official height reference
surface of the German land survey above the reference ellipsoid (GRS80).

A quasigeoid is an approximation of the geoid surface used to define normal
heights above the earth's surface that is based on more practical assumptions
than a true geoid. It defines heights in meters that can be more meaningful
than ellipsoidal heights in many applications like surveying, hydrological
modeling, engineering, or spatial analysis.

This function interfaces the \code{quasigeoid} product of the BKG.
}
\examples{
\dontshow{if (getFromNamespace("ffm_run_examples", ns = "ffm")() && rlang::is_installed("terra")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(terra)
qgeoid <- bkg_quasigeoid(region = "no")
terra::plot(qgeoid)
\dontshow{\}) # examplesIf}
}
