% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fjoin-package.R
\docType{package}
\name{fjoin-package}
\alias{fjoin}
\alias{fjoin-package}
\title{fjoin}
\description{
\pkg{fjoin} builds on \pkg{data.table} to provide fast, flexible joins on any
data frames. It slots into tidyverse pipelines and general workflows in a
single line, and provides NA-safe matching by default, on-the-fly column
selection, flexible row-order preservation, multiple-match handling on both
sides, and an indicator column for row origin.
}
\section{Vignette}{

View the \href{https://trobx.github.io/fjoin/articles/fjoin.html}{Get started}
guide on the \href{https://trobx.github.io/fjoin/index.html}{package website}
or access locally in R with \code{vignette("fjoin")}.
}

\section{API}{

\tabular{ll}{
\strong{fjoin_* functions} \tab \strong{dtjoin_* functions} \cr
\emph{\code{x}/\code{y} style} \tab \emph{Extended \code{DT[i]} style} \cr
\code{\link{fjoin_inner}()}, \code{\link{fjoin_left}()}, \code{\link{fjoin_right}()}, \code{\link{fjoin_full}()} \tab \code{\link{dtjoin}()} \cr
\code{\link{fjoin_left_semi}()} (alias \code{\link{fjoin_semi}()}), \code{\link{fjoin_right_semi}()} \tab \code{\link{dtjoin_semi}()} \cr
\code{\link{fjoin_left_anti}()} (alias \code{\link{fjoin_anti}()}), \code{\link{fjoin_right_anti}()} \tab \code{\link{dtjoin_anti}()} \cr
\code{\link{fjoin_cross}()} \tab \code{\link{dtjoin_cross}()} \cr
}
}

\seealso{
Useful links:
\itemize{
  \item \url{https://trobx.github.io/fjoin/}
  \item Report bugs at \url{https://github.com/trobx/fjoin/issues}
}

}
\author{
\strong{Maintainer}: Toby Robertson \email{trobx@proton.me}

}
\keyword{internal}
