% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_value.R
\name{format_value}
\alias{format_value}
\title{Converts a (possibly compound) value into a string using the \code{format} information}
\usage{
format_value(
  x,
  format = NULL,
  output = c("ascii", "html"),
  na_str = "NA",
  round_type = valid_round_type
)
}
\arguments{
\item{x}{(\code{ANY})\cr the value to be formatted.}

\item{format}{(\code{string} or \code{function})\cr the format label (string) or formatter function to
apply to \code{x}.}

\item{output}{(\code{string})\cr output type.}

\item{na_str}{(\code{character})\cr character vector to display when the values of \code{x} are missing.
If only one string is provided, it is applied for all missing values. Defaults to \code{"NA"}.}

\item{round_type}{(\code{string})\cr .
\cr The type of rounding to perform. Allowed values: (\code{"iec"}, \code{"iec_mod"} or \code{"sas"})
\cr iec, the default, and iec_mod performs rounding compliant with IEC 60559
(see notes in \code{\link[=round_fmt]{round_fmt()}}), while
sas performs nearest-value rounding consistent with rounding within SAS.\cr
In addition, the rounding of a negative number that rounds to zero will be presented as 0
(with the appropriate number of trailing zeros) for both \code{sas} and \code{iec_mod},
while for \code{iec}, it will be presented as -0 (with the appropriate number of trailing zeros).}
}
\value{
Formatted text representing the cell \code{x}.
}
\description{
Converts a (possibly compound) value into a string using the \code{format} information
}
\details{
A length-zero value for \code{na_str} will be interpreted as \code{"NA"}.
}
\examples{
x <- format_value(pi, format = "xx.xx")
x

format_value(x, output = "ascii")

# na_str works with multiple values
format_value(c(NA, 1, NA), format = "xx.x (xx.x - xx.x)", na_str = c("NE", "<missing>"))

}
\seealso{
\code{\link[=round_fmt]{round_fmt()}}
}
