% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frac_style.R
\name{frac_style}
\alias{frac_style}
\title{Style a fracture with superscripts and subscripts}
\usage{
frac_style(fracture, ...)
}
\arguments{
\item{fracture}{A \link{fracture} or a vector to be passed to \code{\link[=fracture]{fracture()}}.}

\item{...}{Additional arguments passed to \code{\link[=fracture]{fracture()}}.}
}
\value{
\code{fracture} with numerators formatted with Unicode superscripts and
denominators formatted with Unicode subscripts.
}
\description{
Uses Unicode superscripts and subscripts to format a fracture.
}
\examples{
frac_style(fracture(0.5))
frac_style(fracture(c(0.5, 1.5), mixed = TRUE))
}
