% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fracture.R
\name{fracture}
\alias{fracture}
\alias{as.fracture}
\alias{is.fracture}
\title{Convert decimals to a character vector of fractions}
\usage{
fracture(
  x,
  ...,
  denom = NULL,
  base_10 = FALSE,
  common_denom = FALSE,
  mixed = FALSE,
  max_denom = 1e+07
)

as.fracture(x)

is.fracture(x)
}
\arguments{
\item{x}{A vector of decimals or, for \code{as.fracture()}, a matrix created by
\code{\link[=frac_mat]{frac_mat()}}}

\item{...}{These dots are for future extensions and must be empty.}

\item{denom}{If \code{denom} is not \code{\link{NULL}}, all fractions will have a
denominator of \code{denom}. This will ignore all other arguments that affect
the denominator.}

\item{base_10}{If \code{TRUE}, all denominators will be a power of 10.}

\item{common_denom}{If \code{TRUE}, all fractions will have the same denominator.

If the least common denominator is greater than \code{max_denom},
\code{max_denom} is used.}

\item{mixed}{If \code{TRUE}, \code{integer} components will be displayed separately
from fractional components for \code{x} values greater than 1.

If \code{FALSE}, improper fractions will be used for \code{x} values greater than 1.}

\item{max_denom}{All denominators will be less than or equal to
\code{max_denom}.

If \code{base_10} is \code{TRUE}, the maximum denominator will be the largest power
of 10 less than \code{max_denom}.

A \code{max_denom} greater than the inverse square root of
\link[=.Machine]{machine double epsilon} will produce a warning because floating
point rounding errors can occur when denominators grow too large.}
}
\value{
A character vector.
}
\description{
Convert decimals to a character vector of fractions
}
\examples{
x <- (6:1) / (1:6)

fracture(x)
fracture(x, common_denom = TRUE)

fracture(x, base_10 = TRUE)
fracture(x, base_10 = TRUE, max_denom = 100)
fracture(x, base_10 = TRUE, common_denom = TRUE)
fracture(x, base_10 = TRUE, common_denom = TRUE, max_denom = 100)

fracture(x, mixed = TRUE)
fracture(x, mixed = TRUE, common_denom = TRUE)
fracture(x, mixed = TRUE, base_10 = TRUE)
fracture(x, mixed = TRUE, base_10 = TRUE, max_denom = 100)
fracture(x, mixed = TRUE, base_10 = TRUE, common_denom = TRUE)
fracture(x, mixed = TRUE, base_10 = TRUE, common_denom = TRUE, max_denom = 100)
}
\seealso{
\code{\link[=frac_mat]{frac_mat()}} to return a matrix of numerators and denominators.
}
