% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_write.R
\name{data_add}
\alias{data_add}
\title{Add an existing file to the data catalog}
\usage{
data_add(
  file_path,
  name = NULL,
  type = NULL,
  delimiter = "comma",
  locked = TRUE,
  update_config = TRUE
)
}
\arguments{
\item{file_path}{Path to the existing file (must exist)}

\item{name}{Optional dot notation name for the data catalog (e.g., \code{inputs.raw.survey_data}).
If NULL, derives name from file path relative to project root.}

\item{type}{Optional type override. Auto-detected from file extension if NULL.}

\item{delimiter}{Delimiter for CSV files ("comma", "tab", "semicolon", "space")}

\item{locked}{Whether the file should be locked (hash-verified on read)}

\item{update_config}{If TRUE (default), also updates the YAML config with the data spec}
}
\value{
Invisibly returns the data spec that was created
}
\description{
Registers an existing data file with the Framework data catalog. This allows
you to track files that were created outside of Framework (e.g., downloaded
from external sources, copied from other projects) and use them with
\code{data_read()} using dot notation.
}
\examples{
\donttest{
if (FALSE) {
# Add a downloaded CSV file to the catalog
data_add("inputs/raw/survey_results.csv", name = "inputs.raw.survey_results")

# Now you can read it with dot notation
data_read("inputs.raw.survey_results")

# Add with auto-generated name
data_add("inputs/intermediate/cleaned_data.rds")
# Name will be derived as "inputs.intermediate.cleaned_data"
}
}

}
