% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/env.R
\name{env_clear}
\alias{env_clear}
\title{Clear R environment}
\usage{
env_clear(keep = character(), envir)
}
\arguments{
\item{keep}{Character vector of object names to keep (default: empty)}

\item{envir}{The environment to clear}
}
\value{
Invisibly returns NULL
}
\description{
Cleans up the R environment by removing objects, closing plots, detaching
packages, and running garbage collection. Does not clear the console.
}
\examples{
\donttest{
if (FALSE) {
# Clean a specific environment
env_clear(envir = my_env)

# Keep specific objects
env_clear(keep = c("config", "data"), envir = my_env)
}
}
}
