% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_notebook.R
\name{make_revealjs}
\alias{make_revealjs}
\title{Create a Reveal.js Presentation}
\usage{
make_revealjs(name, dir = NULL, overwrite = FALSE, subdir = NULL)
}
\arguments{
\item{name}{Character. The presentation name (with or without .qmd extension)}

\item{dir}{Character. Directory to create the file in. Uses your project's
configured \code{directories$notebooks} setting. Default: "notebooks/".}

\item{overwrite}{Logical. Whether to overwrite existing file. Default FALSE.}

\item{subdir}{Optional subdirectory under \code{dir} (e.g., "slides/week-01").}
}
\value{
Invisible path to created presentation
}
\description{
Convenient alias for creating reveal.js presentations. Always creates a Quarto
notebook with the revealjs stub template.
}
\examples{
\donttest{
if (FALSE) {
# Create notebooks/slides.qmd with reveal.js format
make_revealjs("slides")

# Create in specific directory
make_revealjs("presentation", dir = "presentations")
}
}

}
\seealso{
\code{\link[=make_notebook]{make_notebook()}}, \code{\link[=make_qmd]{make_qmd()}}, \code{\link[=make_presentation]{make_presentation()}}
}
