% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_pca.mfd.R
\name{plot_pca_mfd}
\alias{plot_pca_mfd}
\title{Plot the harmonics of a \code{pca_mfd} object}
\usage{
plot_pca_mfd(pca, harm = 0, scaled = FALSE)
}
\arguments{
\item{pca}{A fitted multivariate functional principal component analysis
(MFPCA) object of class \code{pca_mfd}.}

\item{harm}{A vector of integers with the harmonics to plot.
If 0, all harmonics are plotted. Default is 0.}

\item{scaled}{If TRUE, eigenfunctions are multiplied by the square root of the
corresponding eigenvalues, if FALSE the are not scaled and the
all have unit norm.
Default is FALSE}
}
\value{
A ggplot of the harmonics/multivariate functional
principal components contained in the object \code{pca}.
}
\description{
Plot the harmonics of a \code{pca_mfd} object
}
\examples{
library(funcharts)
mfdobj <- data_sim_mfd()
pca_obj <- pca_mfd(mfdobj)
plot_pca_mfd(pca_obj)

}
