% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/real_time_04_phaseII.R
\name{regr_cc_sof_real_time}
\alias{regr_cc_sof_real_time}
\title{Real-time Scalar-on-Function Regression Control Chart}
\usage{
regr_cc_sof_real_time(
  mod_list,
  y_new,
  mfdobj_x_new_list,
  y_tuning = NULL,
  mfdobj_x_tuning_list = NULL,
  alpha = 0.05,
  parametric_limits = TRUE,
  include_covariates = FALSE,
  absolute_error = FALSE,
  ncores = 1
)
}
\arguments{
\item{mod_list}{A list of lists produced by \code{\link{sof_pc_real_time}},
containing a list of scalar-on-function linear regression models estimated
on functional data each evolving up to an intermediate domain point.}

\item{y_new}{A numeric vector containing the observations of
the scalar response variable in the phase II monitoring data set.}

\item{mfdobj_x_new_list}{A list created using
\code{\link{get_mfd_df_real_time}} or
\code{get_mfd_list_real_time}, denoting a list of functional data objects
in the phase II monitoring data set,
each evolving up to an intermediate domain point,
with observations of the multivariate functional covariates.
The length of this list and \code{mod_list} must be equal,
and their elements in the same position in the list
must correspond to the same intermediate domain point.}

\item{y_tuning}{An optional numeric vector containing the observations of
the scalar response variable in the tuning data set.
If NULL, the training data, i.e. the scalar response
in \code{mod_list},
is also used as the tuning data set.
Default is NULL.}

\item{mfdobj_x_tuning_list}{A list created using
\code{\link{get_mfd_df_real_time}} or
\code{get_mfd_list_real_time}, denoting a list of functional data objects
in the tuning data set (used to estimate control chart limits),
each evolving up to an intermediate domain point,
with observations of the multivariate functional covariates.
The length of this list and \code{mod_list} must be equal,
and their elements in the same position in the list
must correspond to the same intermediate domain point.
If NULL, the training data, i.e. the functional covariates
in \code{mod_list},
are also used as the tuning data set.
Default is NULL.}

\item{alpha}{See \code{\link{regr_cc_sof}}.}

\item{parametric_limits}{See \code{\link{regr_cc_sof}}.}

\item{include_covariates}{See \code{\link{regr_cc_sof}}.}

\item{absolute_error}{See \code{\link{regr_cc_sof}}.}

\item{ncores}{If you want parallelization, give the number of cores/threads
to be used when creating objects separately for different instants.}
}
\value{
A list of \code{data.frame}s each
produced by \code{\link{regr_cc_sof}},
corresponding to a given instant.
}
\description{
This function builds a list of data frames,
each of them is produced by \code{\link{regr_cc_sof}}
and is needed to plot control charts for monitoring in real time
a scalar quality characteristic adjusted for
by the effect of multivariate functional covariates.
The training data have already been used to fit the model.
An additional tuning data set can be provided that is used to estimate
the control chart limits.
A phase II data set contains the observations to be monitored
with the built control charts.
}
\examples{
library(funcharts)
data("air")
air1 <- lapply(air, function(x) x[1:8, , drop = FALSE])
air2 <- lapply(air, function(x) x[9:10, , drop = FALSE])
mfdobj_x1_list <- get_mfd_list_real_time(air1[c("CO", "temperature")],
                                         n_basis = 15,
                                         lambda = 1e-2,
                                         k_seq = c(0.5, 1))
mfdobj_x2_list <- get_mfd_list_real_time(air2[c("CO", "temperature")],
                                         n_basis = 15,
                                         lambda = 1e-2,
                                         k_seq = c(0.5, 1))
mfdobj_y1_list <- get_mfd_list_real_time(air1["NO2"],
                                         n_basis = 15,
                                         lambda = 1e-2,
                                         k_seq = c(0.5, 1))
mfdobj_y2_list <- get_mfd_list_real_time(air2["NO2"],
                                         n_basis = 15,
                                         lambda = 1e-2,
                                         k_seq = c(0.5, 1))
mod_list <- fof_pc_real_time(mfdobj_y1_list, mfdobj_x1_list)
cclist <- regr_cc_fof_real_time(
  mod_list = mod_list,
  mfdobj_y_new_list = mfdobj_y2_list,
  mfdobj_x_new_list = mfdobj_x2_list)
plot_control_charts_real_time(cclist, 1)

}
\seealso{
\code{\link{sof_pc_real_time}}, \code{\link{regr_cc_sof}}
}
