% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ARest.R
\name{ARest}
\alias{ARest}
\title{Estimation of Autoregressive (AR) Parameters}
\usage{
ARest(x, ar.order = NULL, ar.method = "HVK", ic = c("BIC", "AIC", "none"))
}
\arguments{
\item{x}{a vector containing a univariate time series. Missing values are not allowed.}

\item{ar.order}{order of the autoregressive model when \code{ic = "none"}, or
the maximal order for IC-based filtering. Default is
\code{round(10*log10(length(x)))}, where \code{x} is the time series.}

\item{ar.method}{method of estimating autoregression coefficients.
Default \code{"HVK"} delivers robust difference-based estimates by
\insertCite{Hall_VanKeilegom_2003;textual}{funtimes}. Alternatively,
options of \command{ar} function can be used, such as \code{"burg"},
\code{"ols"}, \code{"mle"}, and \code{"yw"}.}

\item{ic}{information criterion used to select the order of autoregressive filter (AIC of BIC),
considering models of orders \eqn{p=} 0,1,...,\code{ar.order}.
If \code{ic = "none"}, the AR(\eqn{p}) model with \eqn{p=} \code{ar.order} is used,
without order selection.}
}
\value{
A vector of estimated AR coefficients. Returns \code{numeric(0)} if
the final \eqn{p=0}.
}
\description{
Estimate parameters \eqn{\phi} of autoregressive time series model
\deqn{X_t = \sum_{i=1}^p\phi_iX_{t-i} + e_t,}
by default using robust difference-based estimator and Bayesian information
criterion (BIC) to select the order \eqn{p}. This function is employed
for time series filtering in the functions \code{\link{notrend_test}}, \code{\link{sync_test}},
and \code{\link{wavk_test}}.
}
\details{
The formula for information criteria used consistently for all methods:
\deqn{IC=n\ln(\hat{\sigma}^2) + (p + 1)k,}
where \eqn{n} = \code{length(x)},
\eqn{p} is the autoregressive order (\eqn{p + 1} is the number of model parameters),
and \eqn{k} is the penalty (\eqn{k = \ln(n)} in BIC, and \eqn{k = 2} in AIC).
}
\examples{
# Simulate a time series Y:
Y <- arima.sim(n = 200, list(order = c(2, 0, 0), ar = c(-0.7, -0.1)))
plot.ts(Y)

# Estimate the coefficients:
ARest(Y) # HVK, by default
ARest(Y, ar.method = "yw") # Yule--Walker
ARest(Y, ar.method = "burg") # Burg

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[stats]{ar}}, \code{\link{HVK}},
\code{\link{notrend_test}}, \code{\link{sync_test}}, \code{\link{wavk_test}}
}
\author{
Vyacheslav Lyubchich
}
\keyword{ts}
