% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/causality_predVAR.R
\name{causality_predVAR}
\alias{causality_predVAR}
\title{Out-of-sample Tests of Granger Causality using (Restricted) Vector Autoregression}
\usage{
causality_predVAR(
  y,
  p = NULL,
  cause = NULL,
  B = 500L,
  test = 0.3,
  cl = 1L,
  ...
)
}
\arguments{
\item{y}{data frame or \code{ts} object for estimating VAR(\eqn{p}).}

\item{p}{an integer specifying the order \eqn{p} in VAR.
By default (if \code{p} is not specified),
\eqn{p} is selected based on the information criterion
\code{ic} (see \code{...} arguments; default \code{ic} is AIC).}

\item{cause}{name of the cause variable. If not specified, the first variable in
\code{y} is treated as the dependent variable and the second is treated as the cause.}

\item{B}{number of bootstrap replications. Default is 500.}

\item{test}{a numeric value specifying the size of the testing set. If \code{test} < 1,
the value is treated as a proportion of the sample size to be used as the testing set.
Otherwise, \code{test} is treated as the number of the most recent values to be used as the testing set.
Default is 0.3, which means that 30\% of the sample is used for calculating
out-of-sample errors. The testing set is always at the end of the time series.}

\item{cl}{parameter to specify computer cluster for bootstrapping passed to
the package \code{parallel} (default \code{cl = 1}, means no cluster is used).
Possible values are:
\itemize{
\item cluster object (list) produced by \link[parallel]{makeCluster}.
In this case, a new cluster is not started nor stopped;
\item \code{NULL}. In this case, the function will detect
available cores (see \link[parallel]{detectCores}) and, if there are
multiple cores (\eqn{>1}), a cluster will be started with
\link[parallel]{makeCluster}. If started, the cluster will be stopped
after the computations are finished;
\item positive integer defining the number of cores to start a cluster.
If \code{cl = 1} (default), no attempt to create a cluster will be made.
If \code{cl} > 1, a cluster will be started (using \link[parallel]{makeCluster})
and stopped afterward (using \link[parallel]{stopCluster}).
}}

\item{...}{other arguments passed to the function for VAR estimation.
The arguments include \code{lag.restrict} that is used to remove the first lags
in the cause variable from consideration (use restricted VAR to avoid testing for short-term causality);
default \code{lag.restrict = 0L}, i.e., no restrictions.
Other possible arguments are as in the \code{\link[vars]{VAR}} function.
Also, see Details and Examples.}
}
\value{
Two lists (one for the fast bootstrap,
another for the bootstrap under the null hypothesis) each containing the following elements:
\item{result}{a table with the observed values of the test statistics and \eqn{p}-values.}
\item{cause}{the cause variable.}
\item{p}{the AR order used.}
}
\description{
Test for Granger causality using out-of-sample prediction errors from a vector
autoregression (VAR), where the original VAR can be restricted (see Details).
The tests include the MSE-t approach \insertCite{McCracken_2007}{funtimes} and
MSE-correlation test as in Chapter 9.3 of \insertCite{Granger_Newbold_2016;textual}{funtimes}.
The bootstrap is used to empirically derive distributions of the statistics.
}
\details{
The arguments specified in \code{...} are passed to the \code{\link[vars]{VAR}} function.
Additionally, \code{lag.restrict} can be specified to remove short-term lags from
consideration (\code{lag.restrict} is not an option in the original package \code{vars}).
Note that if \code{p} is specified, \code{lag.restrict} must be smaller
than \code{p} otherwise the default \code{lag.restrict = 0} will be used.
If \code{lag.max} is specified instead of \code{p}, VAR orders
\code{lag.restrict} + 1, \dots, \code{lag.max} will be considered using the training data
and the order \eqn{p} will be automatically selected according to the information criterion
(by default, AIC).

In the current implementation, the bootstrapped \eqn{p}-value is calculated using equation 4.10 of
\insertCite{Davison_Hinkley_1997;textual}{funtimes}: \code{p.value} = (1 + \eqn{n}) / (\code{B} + 1),
where \eqn{n} is the number of bootstrapped statistics smaller or equal to the observed statistic.
In the fast bootstrap, \eqn{n} is the number of bootstrapped statistics greater or equal to 0.

This function uses symmetric VAR with the same orders \eqn{p} for modeling both \eqn{Y} to \eqn{X}.
To select these orders more independently, consider using the function \code{\link{causality_pred}}.
}
\examples{
\dontrun{
# Example 1: Canada time series (ts object)
Canada <- vars::Canada
causality_predVAR(Canada[,1:2], cause = "e", lag.max = 5)
causality_predVAR(Canada[,1:2], cause = "e", lag.restrict = 3, lag.max = 15)

# Example 2 (run in parallel, initiate the cluster manually):
# Box & Jenkins time series
# of sales and a leading indicator, see ?BJsales

# Initiate a local cluster
cores <- parallel::detectCores()
cl <- parallel::makeCluster(cores)
parallel::clusterSetRNGStream(cl, 123) # to make parallel computations reproducible

D <- cbind(BJsales.lead, BJsales)
causality_predVAR(D, cause = "BJsales.lead", lag.max = 5, B = 1000, cl = cl)
causality_predVAR(D, cause = "BJsales.lead", lag.restrict = 3, p = 5, B = 1000, cl = cl)
parallel::stopCluster(cl)
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{causality_pred}}
}
\author{
Vyacheslav Lyubchich
}
\keyword{causality}
\keyword{htest}
\keyword{ts}
