% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plugins.R
\name{context_menu}
\alias{context_menu}
\title{Configure Context Menu Behavior}
\usage{
context_menu(
  key = "contextmenu",
  className = "g6-contextmenu",
  trigger = "contextmenu",
  offset = c(4, 4),
  onClick = NULL,
  getItems = NULL,
  getContent = NULL,
  loadingContent = NULL,
  enable = JS("(e) => e.targetType === 'node'"),
  ...
)
}
\arguments{
\item{key}{Unique identifier for the behavior, used for
subsequent operations (string, default: "context-menu").}

\item{className}{Additional class name for the menu DOM (string, default: "g6-contextmenu").}

\item{trigger}{How to trigger the menu: "contextmenu" for right-click,
"click" for click (string, default: "contextmenu").}

\item{offset}{Offset of the menu display in X and Y directions (numeric vector, default: c(4, 4)).}

\item{onClick}{Callback method triggered after menu item is clicked (JS function). Our default allows
to create edge or either remove the current node.}

\item{getItems}{Returns the list of menu items, supports Promise (JS function, default: NULL).}

\item{getContent}{Returns the content of the menu, supports Promise (JS function, default: NULL).}

\item{loadingContent}{Menu content used when getContent returns a
Promise (string or HTML element, default: NULL).}

\item{enable}{Whether the context menu is available (boolean or JS function, default: TRUE).}

\item{...}{Extra parameters.
See \url{https://g6.antv.antgroup.com/en/manual/plugin/contextmenu}.}
}
\value{
A list with the configuration settings for the context menu plugin.
}
\description{
Creates a configuration object for the context-menu behavior in G6.
This allows users to display a context menu when right-clicking or clicking on graph elements.
}
\examples{
# Basic configuration
config <- context_menu()

# Custom configuration with JavaScript functions
config <- context_menu(
  key = "my-context-menu",
  className = "my-context-menu",
  trigger = "click",
  offset = c(10, 10),
  getItems = JS("(event) => {
    const type = event.itemType;
    const isNode = type === 'node';
    return [
      { key: 'delete', text: 'Delete' },
      { key: 'edit', text: 'Edit' },
      { key: 'details', text: 'View Details', disabled: !isNode }
    ];
  }"),
  onClick = JS("(value, target, current) => {
    if (value === 'delete') {
      // do stuff
  }")
)
if (interactive()) {
  library(shiny)
  library(g6R)
  library(bslib)

  nodes <- data.frame(id = c("node1", "node2"))
  edges <- data.frame(source = "node1", target = "node2")

  ui <- page_fluid(
    g6_output("graph"),
    verbatimTextOutput("contextmenu_info")
  )

  server <- function(input, output, session) {
    output$graph <- render_g6({
      g6(
        nodes = nodes,
        edges = edges
      ) |>
        g6_layout() |>
        g6_plugins(
          context_menu()
        )
    })

    output$contextmenu_info <- renderPrint({
      input[["graph-contextmenu"]]
    })
  }

  shinyApp(ui, server)
}
}
