% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/behaviors.R
\name{g6_behaviors}
\alias{g6_behaviors}
\title{Create G6 Graph Behaviors Configuration}
\usage{
g6_behaviors(graph, ...)
}
\arguments{
\item{graph}{A g6 graph instance.}

\item{...}{Behavior configuration objects created by behavior-specific functions.
These can include any of the following behaviors:

\strong{Navigation behaviors:}
\itemize{
\item \code{drag_canvas()} - Drag the entire canvas view
\item \code{zoom_canvas()} - Zoom the canvas view
\item \code{scroll_canvas()} - Scroll the canvas using the wheel
\item \code{optimize_viewport_transform()} - Optimize view transform performance
}

\strong{Selection behaviors:}
\itemize{
\item \code{click_select()} - Click to select graph elements
\item \code{brush_select()} - Select elements by dragging a rectangular area
\item \code{lasso_select()} - Freely draw an area to select elements
}

\strong{Editing behaviors:}
\itemize{
\item \code{create_edge()} - Interactively create new edges
\item \code{drag_element()} - Drag nodes or combos
\item \code{drag_element_force()} - Drag nodes in force-directed layout
}

\strong{Data Exploration behaviors:}
\itemize{
\item \code{collapse_expand()} - Expand or collapse subtree nodes
\item \code{focus_element()} - Focus on specific elements and automatically adjust the view
\item \code{hover_activate()} - Highlight elements when hovering
}

\strong{Visual Optimization behaviors:}
\itemize{
\item \code{fix_element_size()} - Fix the element size to a specified value
\item \code{auto_adapt_label()} - Automatically adjust label position
}}
}
\value{
A list of behavior configuration objects that can be passed to G6 graph initialization
}
\description{
Configures interaction behaviors for a G6 graph visualization.
This function collects and combines multiple behavior configurations
into a list that can be passed to graph initialization functions.
}
\note{
You can create custom behaviors from JavaScript and use them on the R side. See more
at \url{https://g6.antv.antgroup.com/en/manual/behavior/custom-behavior}.
}
\examples{
# Create a basic set of behaviors
behaviors <- g6_behaviors(
  g6(),
  drag_canvas(),
  zoom_canvas(),
  click_select()
)

# Create a more customized set of behaviors
behaviors <- g6_behaviors(
  g6(),
  drag_canvas(),
  zoom_canvas(sensitivity = 1.5),
  hover_activate(state = "highlight"),
  fix_element_size(
    node = list(
      list(shape = "circle", fields = c("r", "lineWidth"))
    )
  )
)

}
