% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdService.R
\name{gdServiceGetGenerativeModel}
\alias{gdServiceGetGenerativeModel}
\title{Get generative model from software service for accelerated training of
generative models for processed job}
\usage{
gdServiceGetGenerativeModel(
  url,
  accessKey,
  jobId,
  generativeModelFileName = NULL
)
}
\arguments{
\item{url}{URL of software service for accelerated training of generative
models}

\item{accessKey}{Unique key for access to software service}

\item{jobId}{Job id for generated job for training a generative model}

\item{generativeModelFileName}{Name of generative model file. If name is NULL
or empty string name of passed name to function gdServiceTrain() will be used.}
}
\value{
None
}
\description{
Download trained generative model from software service for processed job.
The status of the job has to be TRAINED.
}
\examples{
\dontrun{
url <- "http://xxx.xxx.xxx.xxx/gdService"
accessKey <- "xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx"
gdServiceGetGenerativeModel(url, accessKey, 1,  "gm.bin")}
}
