% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_ms.R
\name{batch_ms}
\alias{batch_ms}
\title{Finds batch of mass spectra}
\usage{
batch_ms(data, t_peaks, tolerance = 5e-04)
}
\arguments{
\item{data}{a \emph{list} object. Data extracted from a cdf file,
ideally the output from extract_data().}

\item{t_peaks}{a \emph{vector} object. A list of times at which the peaks of
interest are located in the overall time index for the sample.}

\item{tolerance}{a \emph{double} object. The tolerance allowed for the time
index. Default is 0.0005.}
}
\value{
A \emph{list} object of \emph{data.frame} objects. Each a data frame
of the mass values and the percent intensity values.
}
\description{
\code{batch_ms} Finds batch of mass spectra of peaks.
}
\details{
This function uses find_ms() to find the mass spectra values of
a batch list of peaks in intensity values of a GCxGC sample at overall time
index values specified in a txt or csv file. It outputs a list of data
frames, for each peak, of the mass values and percent intensity values which
can then be plotted to product the mass spectra plot.
}
\examples{
file <- system.file("extdata","sample1.cdf",package="gcxgclab")
frame <- extract_data(file,mod_t=.5)
peaks <- top_peaks(frame$TIC_df, 5)
mzs <- batch_ms(frame, t_peaks = peaks$'T'[1:5])
for (i in 1:length(mzs)){
   print(plot_ms(mzs[[i]], title=paste('Mass Spectrum of peak', i)))
}

}
