% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geessbin_all.R
\name{geessbin_all}
\alias{geessbin_all}
\title{Function for analysis using all combinations of GEE methods and covariance
estimators}
\usage{
geessbin_all(
  formula,
  data = parent.frame(),
  id = NULL,
  corstr = "independence",
  repeated = NULL,
  b = NULL,
  maxitr = 50,
  tol = 1e-05,
  scale.fix = FALSE,
  conf.level = 0.95
)
}
\arguments{
\item{formula}{Object of class formula: symbolic description of model to be
fitted (see documentation of \code{lm} and
\code{formula} for details).}

\item{data}{Data frame.}

\item{id}{Vector that identifies the subjects or clusters (\code{NULL} by
default).}

\item{corstr}{Working correlation structure. The following are permitted:
"\code{independence}", "\code{exchangeable}", "\code{ar1}", and
"\code{unstructured}" ("\code{independence}" by default).}

\item{repeated}{Vector that identifies repeatedly measured variable within
each subject or cluster. If \code{repeated = NULL}, as is the case in
function \code{gee}, data are assumed to be sorted so that
observations on a cluster are contiguous rows for all entities
in the formula.}

\item{b}{Numeric vector specifying initial values of regression coefficients.
If \code{b = NULL} (default value), the initial values are calculated
using the ordinary or Firth logistic regression assuming that all the
observations are independent.}

\item{maxitr}{Maximum number of iterations (50 by default).}

\item{tol}{Tolerance used in fitting algorithm (\code{1e-5} by default).}

\item{scale.fix}{Logical variable; if \code{TRUE}, the scale parameter is
fixed at 1 (\code{FALSE} by default).}

\item{conf.level}{Numeric value of confidence level for confidence intervals
(0.95 by default).}
}
\value{
The list containing two data frames.
The first is a table of estimates of regression coefficients, standard
errors, z-values, and p-values.
The second is a table of odds ratios and confidence intervals.
}
\description{
\code{geessbin_all} provides analysis results using all combinations of three
GEE methods and 12 covariance estimators.
}
