% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/07-interpolation.R
\name{spatial_interpolation}
\alias{spatial_interpolation}
\title{Legacy spatial interpolation function (for backward compatibility)}
\usage{
spatial_interpolation(
  spatial_data,
  target_variables,
  method = "NN",
  power = 2,
  mice_method = "pmm"
)
}
\arguments{
\item{spatial_data}{sf object with some missing values}

\item{target_variables}{Variables to interpolate}

\item{method}{Interpolation method: "NN", "simple", "mice"}

\item{power}{Power parameter for simple method (default: 2)}

\item{mice_method}{MICE method for multivariate imputation}
}
\value{
sf object with interpolated values
}
\description{
Simplified version of spatial interpolation maintaining backward compatibility.
For new projects, use spatial_interpolation_comprehensive() instead.
}
\examples{
\dontrun{
# These examples require external data files not included with the package
# Simple interpolation (legacy interface)
interpolated_data <- spatial_interpolation(
  soil_data,
  target_variables = c("nitrogen", "carbon"),
  method = "NN"
)
}

}
