% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/girafe.R
\name{girafe}
\alias{girafe}
\title{Create a girafe object}
\usage{
girafe(
  ggobj = NULL,
  code,
  pointsize = 12,
  width_svg = NULL,
  height_svg = NULL,
  options = list(),
  font_set = NULL,
  dependencies = NULL,
  check_fonts_registered = FALSE,
  check_fonts_dependencies = FALSE,
  ...
)
}
\arguments{
\item{ggobj}{ggplot object to print. Argument \code{code} will
be ignored if this argument is supplied.}

\item{code}{Plotting code to execute}

\item{pointsize}{the default pointsize of plotted text in pixels, default to 12.}

\item{width_svg, height_svg}{The width and height of the graphics region in inches.
The default values are 6 and 5 inches. This will define the aspect ratio of the
graphic as it will be used to define viewbox attribute of the SVG result.

If you use \code{girafe()} in an 'R Markdown' document, we
recommend not using these arguments so that the knitr
options \code{fig.width} and \code{fig.height} are used instead.}

\item{options}{a list of options for girafe rendering, see
\code{\link[=opts_tooltip]{opts_tooltip()}}, \code{\link[=opts_hover]{opts_hover()}}, \code{\link[=opts_selection]{opts_selection()}}, ...}

\item{font_set}{A \code{\link[gdtools:font_set]{gdtools::font_set()}} object controlling font
aliases and HTML dependencies. The default is
\code{\link[gdtools:font_set_liberation]{gdtools::font_set_liberation()}}, which uses Liberation fonts
(bundled by 'fontquiver' under the SIL Open Font License).
This makes output reproducible offline without requiring
any system font.

For system-aware font selection use \code{\link[gdtools:font_set_auto]{gdtools::font_set_auto()}},
or build a custom configuration with \code{\link[gdtools:font_set]{gdtools::font_set()}}.

\code{font_set$dsvg_fonts} is passed as \code{fonts} argument to \code{\link[=dsvg]{dsvg()}} and
\code{font_set$dependencies} are appended to \code{dependencies}.}

\item{dependencies}{Additional widget HTML dependencies, see \code{\link[htmlwidgets:createWidget]{htmlwidgets::createWidget()}}.}

\item{check_fonts_registered}{whether to check if fonts families found in
the ggplot are registered with 'systemfonts'.}

\item{check_fonts_dependencies}{whether to check if fonts families found in
the ggplot are found in the \code{dependencies} list.}

\item{...}{arguments passed on to \code{\link[=dsvg]{dsvg()}}}
}
\description{
Create an interactive graphic with a ggplot object
to be used in a web browser.
}
\details{
Use \code{geom_zzz_interactive} to create interactive graphical elements.

Tooltips can be displayed when mouse is over graphical elements.

If id are associated with points, they get animated when mouse is
over and can be selected when used in shiny apps.

On click actions can be set with javascript instructions. This option
should not be used simultaneously with selections in Shiny
applications as both features are "on click" features.

When a zoom effect is set, "zoom activate", "zoom desactivate" and
"zoom init" buttons are available in a toolbar.

When selection type is set to 'multiple' (in Shiny applications), lasso
selection and lasso anti-selections buttons are available in a toolbar.
}
\section{Managing Grouping with Interactive Aesthetics}{


Adding an interactive aesthetic like \code{tooltip} can sometimes alter the implicit
grouping that ggplot2 performs automatically.

In these cases, you \strong{must explicitly} specify the \code{group} aesthetic to ensure
correct graph rendering by clearly defining the variables that determine the
grouping.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{mapping = ggplot2::aes(tooltip = .data_tooltip, group = interaction(factor1, factor2, ...))
}\if{html}{\out{</div>}}

This precaution is necessary:
\itemize{
\item ggplot2 automatically determines grouping based on the provided aesthetics
\item Interactive aesthetics added by ggiraph can interfere with this logic
\item Explicit \code{group} specification prevents unexpected behavior and ensures predictable results
}
}

\section{Widget options}{

girafe animations can be customized with function \code{\link[=girafe_options]{girafe_options()}}.
Options are available to customize tooltips, hover effects, zoom effects
selection effects and toolbar.

Options passed to \code{girafe()} are merged with defaults set via
\code{\link[=set_girafe_defaults]{set_girafe_defaults()}}. This means you can define global styles once
and override only specific parameters per plot. For example, if you set
a custom tooltip CSS globally, you can still adjust \code{offx} and \code{offy}
in a specific \code{girafe()} call without losing your CSS styling.
}

\section{Widget sizing}{

girafe graphics are responsive, which mean, they will be resized
according to their container. There are two responsive behavior
implementations:
\itemize{
\item one for Shiny applications and flexdashboard documents,
\item and another one for other documents (i.e. R markdown and \code{saveWidget}).
}

Graphics are created by an R graphic device (i.e pdf, png, svg here) and
need arguments width and height to define a graphic region.
Arguments \code{width_svg} and \code{height_svg} are used as corresponding
values. They are defining the aspect ratio of the graphic. This proportion is
always respected when the graph is displayed.

When a girafe graphic is in a Shiny application,
graphic will be resized according to the arguments \code{width} and
\code{height} of the function \code{girafeOutput}. Default
values are '100\\%' and NULL. These arguments determine the
outer bounding box of the graphic (the HTML element that will
contain the graphic with an aspect ratio).

When a girafe graphic is in an R markdown document (producing an HTML
document), the graphic will be resized according to the argument \code{width} of the
function \code{girafe}. Its value is beeing used to define a relative
width of the graphic within its HTML container. Its height is automatically
adjusted regarding to the argument \code{width} and the aspect ratio.
}

\examples{
library(ggplot2)
library(ggiraph)
library(gdtools)

fonts <- font_set(sans = font_liberation("sans"))

dataset <- mtcars
dataset$carname <- row.names(mtcars)

gg_point <- ggplot(
  data = dataset,
  mapping = aes(
    x = wt,
    y = qsec,
    color = disp,
    tooltip = carname,
    data_id = carname
  )
) +
  geom_point_interactive(hover_nearest = TRUE, size = 11 / .pt) +
  theme_minimal(base_family = fonts$sans, base_size = 11)

x <- girafe(
  ggobj = gg_point,
  font_set = fonts
)

x
}
\seealso{
\code{\link[=girafe_options]{girafe_options()}}, \code{\link[=dsvg]{dsvg()}}, \code{\link[gdtools:font_set]{gdtools::font_set()}}
}
