% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operations.R
\name{ggml_cont}
\alias{ggml_cont}
\title{Make Contiguous (Graph)}
\usage{
ggml_cont(ctx, a)
}
\arguments{
\item{ctx}{GGML context}

\item{a}{Input tensor}
}
\value{
Contiguous tensor
}
\description{
Makes a tensor contiguous in memory. Required after permute/transpose
before some operations.
}
\examples{
\donttest{
ctx <- ggml_init(16 * 1024 * 1024)
a <- ggml_new_tensor_2d(ctx, GGML_TYPE_F32, 3, 4)
ggml_set_f32(a, 1:12)
transposed <- ggml_transpose(ctx, a)
contiguous <- ggml_cont(ctx, transposed)
ggml_free(ctx)
}
}
