% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operations.R
\name{ggml_quantize_chunk}
\alias{ggml_quantize_chunk}
\title{Quantize Data Chunk}
\usage{
ggml_quantize_chunk(type, src, nrows, n_per_row)
}
\arguments{
\item{type}{Target GGML type (e.g., GGML_TYPE_Q4_0)}

\item{src}{Source numeric vector (F32 data)}

\item{nrows}{Number of rows}

\item{n_per_row}{Number of elements per row}
}
\value{
Raw vector containing quantized data
}
\description{
Quantizes a chunk of floating-point data to a lower precision format.
}
\examples{
\donttest{
# Quantize 256 floats to Q8_0 (block size 32)
data <- rnorm(256)
quantized <- ggml_quantize_chunk(GGML_TYPE_Q8_0, data, 1, 256)
ggml_quantize_free()  # Clean up
}
}
