% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operations.R
\name{ggml_reshape_2d}
\alias{ggml_reshape_2d}
\title{Reshape to 2D (Graph)}
\usage{
ggml_reshape_2d(ctx, a, ne0, ne1)
}
\arguments{
\item{ctx}{GGML context}

\item{a}{Input tensor}

\item{ne0}{Size of dimension 0}

\item{ne1}{Size of dimension 1}
}
\value{
Reshaped tensor
}
\description{
Reshapes tensor to 2D with shape (ne0, ne1)
}
\examples{
\donttest{
ctx <- ggml_init(16 * 1024 * 1024)
a <- ggml_new_tensor_1d(ctx, GGML_TYPE_F32, 12)
ggml_set_f32(a, 1:12)
result <- ggml_reshape_2d(ctx, a, 3, 4)
ggml_free(ctx)
}
}
