% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tensors.R
\name{ggml_new_tensor}
\alias{ggml_new_tensor}
\title{Create Tensor with Arbitrary Dimensions}
\usage{
ggml_new_tensor(ctx, type = GGML_TYPE_F32, n_dims, ne)
}
\arguments{
\item{ctx}{GGML context}

\item{type}{Data type (GGML_TYPE_F32, etc.)}

\item{n_dims}{Number of dimensions (1-4)}

\item{ne}{Numeric vector of dimension sizes}
}
\value{
Tensor pointer
}
\description{
Generic tensor constructor for creating tensors with 1-4 dimensions.
This is more flexible than the ggml_new_tensor_Nd functions.
}
\examples{
\donttest{
ctx <- ggml_init(1024 * 1024)
t <- ggml_new_tensor(ctx, GGML_TYPE_F32, 3, c(10, 20, 30))
ggml_nelements(t)
ggml_free(ctx)
}
}
