% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kinship2_autohints.R
\name{kinship2_autohint}
\alias{kinship2_autohint}
\title{Automatically generate alignment hints for pedigree plotting}
\usage{
kinship2_autohint(ped, hints, packed = TRUE, align = FALSE)
}
\arguments{
\item{ped}{A pedigree object}

\item{hints}{Optional existing hints (list with `order` and optionally `spouse` components)}

\item{packed}{Logical, if TRUE uses compact packing algorithm (default TRUE)}

\item{align}{Logical, if TRUE attempts to align spouses on the same level (default FALSE)}
}
\value{
A list containing:
  \item{order}{Numeric vector of relative ordering hints for subjects}
  \item{spouse}{Matrix of spouse pair information}
}
\description{
This function automatically generates alignment hints for pedigree plotting.
Hints control the relative horizontal positioning of subjects within their
generation and the placement of spouse pairs. The function handles twins,
multiple marriages, and complex pedigree structures.
}
\details{
The function is called automatically by kinship2_align.pedigree if no hints
are provided. It analyzes the pedigree structure, identifies twins, handles
multiple marriages, and determines optimal subject ordering to minimize
crossing lines and produce aesthetically pleasing plots.

Full documentation is available in the align_code_details vignette.
}
\keyword{internal}
