% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discrete-iterm.R
\name{pal_iterm}
\alias{pal_iterm}
\title{iTerm color palettes}
\usage{
pal_iterm(
  palette = iterm_palettes(),
  variant = c("normal", "bright"),
  alpha = 1
)
}
\arguments{
\item{palette}{Palette name. See \code{\link[=iterm_palettes]{iterm_palettes()}} for available options.}

\item{variant}{Variant of the palette. One of \code{"normal"}, \code{"bright"}.}

\item{alpha}{Transparency level, a real number in (0, 1].
See \code{alpha} in \code{\link[grDevices:rgb]{grDevices::rgb()}} for details.}
}
\description{
ANSI terminal color palettes sourced from the iterm2-color-schemes project.
Each theme provides normal and bright variants.
}
\details{
Preview all available iTerm color palettes in ggsci:
\url{https://nanx.me/ggsci-iterm/}.
}
\examples{
library("scales")
show_col(pal_iterm("Rose Pine")(6))
show_col(pal_iterm("Rose Pine", variant = "bright", alpha = 0.7)(6))
}
\references{
\url{https://github.com/mbadolato/iTerm2-Color-Schemes}
}
